/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.dao;

import com.atlassian.pocketknife.api.querydsl.DatabaseCompatibilityKit;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.dml.DMLClause;
import com.querydsl.sql.dml.SQLInsertClause;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryDslDaoHelper {
    private final DatabaseCompatibilityKit databaseCompatibilityKit;

    @Autowired
    public QueryDslDaoHelper(DatabaseCompatibilityKit databaseCompatibilityKit) {
        this.databaseCompatibilityKit = databaseCompatibilityKit;
    }

    public long executeSingleRowInsertReturningId(DatabaseConnection databaseConnection, SQLInsertClause insertClause) {
        return (Long)this.databaseCompatibilityKit.executeWithKey(databaseConnection, insertClause, Long.class);
    }

    public long executeMultipleRowUpdates(DMLClause dmlClause, long expectedUpdateRowCount) {
        long numberOfRowsUpdated = dmlClause.execute();
        if (numberOfRowsUpdated != expectedUpdateRowCount) {
            throw new RuntimeException("Expected number of rows " + expectedUpdateRowCount + " to be updated does not match number of rows updated " + numberOfRowsUpdated);
        }
        return numberOfRowsUpdated;
    }
}

