/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.condition;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import io.atlassian.fugue.Option;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgentAdminAccessCondition
implements Condition {
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public AgentAdminAccessCondition(ServiceDeskPermissionService serviceDeskPermissionService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Option shouldDisplayOpt = Steps.begin((Option)Option.option((Object)this.jiraAuthenticationContext.getLoggedInUser())).then(user -> this.getServiceDeskFromContext(context)).yield((user, sd) -> this.isAdminAgent((ApplicationUser)user, (ServiceDesk)sd));
        return (Boolean)shouldDisplayOpt.getOrElse((Object)false);
    }

    private boolean isAdminAgent(ApplicationUser user, ServiceDesk serviceDesk) {
        return (Boolean)this.serviceDeskPermissionService.isAdminAgent(user, serviceDesk).toOption().getOrElse((Object)false);
    }

    private Option<ServiceDesk> getServiceDeskFromContext(Map<String, Object> context) {
        Object serviceDesk = context.get("serviceDesk");
        if (serviceDesk == null || !(serviceDesk instanceof ServiceDesk)) {
            return Option.none();
        }
        return Option.some((Object)((ServiceDesk)serviceDesk));
    }
}

