/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.collector.translator;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.plugins.reports.internal.collector.input.DateTimeValue;
import com.atlassian.servicedesk.plugins.reports.internal.collector.translator.LuceneTranslator;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class AverageRatingTranslator
implements LuceneTranslator<DateTimeValue<Integer>> {
    private final CustomField feedbackField;
    private final CustomField feedbackDateField;
    private final DateTimeZone zone;
    private Option<DateTime> timeOpt;
    private Option<Integer> ratingOpt;

    public AverageRatingTranslator(CustomField feedbackField, CustomField feedbackDateField, DateTimeZone zone) {
        this.feedbackField = feedbackField;
        this.feedbackDateField = feedbackDateField;
        this.zone = zone;
        this.timeOpt = Option.none();
        this.ratingOpt = Option.none();
    }

    @Override
    public void addField(Long issueId, String issueKey, String fieldName, String data) {
        if (StringUtils.isNotBlank((String)fieldName)) {
            if (fieldName.equals(this.feedbackField.getId())) {
                this.ratingOpt = Option.some((Object)NumberUtils.toInt((String)data));
            } else if (fieldName.equals(this.feedbackDateField.getId())) {
                this.timeOpt = Option.some((Object)new DateTime((Object)LuceneUtils.stringToDate((String)data), this.zone));
            }
        }
    }

    @Override
    public Option<DateTimeValue<Integer>> build(Long issueId, String issueKey) {
        return Steps.begin(this.timeOpt).then(time -> this.ratingOpt).yield((time, rating) -> new DateTimeValue<Integer>(time.getMillis(), (Integer)rating));
    }

    @Override
    public Set<String> relevantFields() {
        return Sets.newHashSet((Object[])new String[]{this.feedbackField.getId(), this.feedbackDateField.getId()});
    }
}

