/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.collector;

import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.servicedesk.plugins.reports.internal.collector.DataCollector;
import com.atlassian.servicedesk.plugins.reports.internal.collector.input.DateTimeValue;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.DataCollectorResult;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.IntervalValue;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.joda.time.Interval;

@LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueAggregation)
public class CountCollector
implements DataCollector<DateTimeValue<Long>, DataCollectorResult<Long>> {
    private final long[] buckets;
    private long sum;
    private final Timescale timescale;

    public CountCollector(Timescale timescale) {
        this.timescale = timescale;
        this.buckets = new long[timescale.getTimeIntervals().size()];
        this.sum = 0L;
    }

    @Override
    public void collect(DateTimeValue<Long> input) {
        this.timescale.getBucketIndex(input.getDateTimeMillis()).forEach(index -> {
            int n = index;
            this.buckets[n] = this.buckets[n] + (Long)input.getValue();
            this.sum += ((Long)input.getValue()).longValue();
        });
    }

    @Override
    public DataCollectorResult<Long> data() {
        List<Interval> timeIntervals = this.timescale.getTimeIntervals();
        List intervalValues = IntStream.range(0, this.buckets.length).mapToObj(index -> new IntervalValue<Long>((Interval)timeIntervals.get(index), this.buckets[index])).collect(Collectors.toList());
        return new DataCollectorResult<Long>(intervalValues, this.sum);
    }
}

