/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.collector;

import com.atlassian.servicedesk.plugins.reports.internal.collector.DataCollector;
import com.atlassian.servicedesk.plugins.reports.internal.collector.input.DateTimeValue;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.DataCollectorResult;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;

public abstract class AbstractAverageCollector<In extends Number, Out extends Number>
implements DataCollector<DateTimeValue<In>, DataCollectorResult<Out>> {
    protected final Timescale timescale;
    protected final long[] countBucket;
    protected long totalIssues;
    protected final long[] bucketSums;
    protected long totalSum;

    public AbstractAverageCollector(Timescale timescale) {
        this.timescale = timescale;
        this.countBucket = new long[timescale.getTimeIntervals().size()];
        this.bucketSums = new long[timescale.getTimeIntervals().size()];
        this.totalSum = 0L;
        this.totalIssues = 0L;
    }

    @Override
    public void collect(DateTimeValue<In> input) {
        this.timescale.getBucketIndex(input.getDateTimeMillis()).forEach(index -> {
            int n = index;
            this.bucketSums[n] = this.bucketSums[n] + ((Number)input.getValue()).longValue();
            this.totalSum += ((Number)input.getValue()).longValue();
            int n2 = index;
            this.countBucket[n2] = this.countBucket[n2] + 1L;
            ++this.totalIssues;
        });
    }
}

