/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.bootstrap;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.servicedesk.plugins.reports.internal.bootstrap.database.StatsEventDatabaseShredder;
import com.atlassian.servicedesk.plugins.reports.internal.listener.StatsEventListeners;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ReportsPluginLauncher
implements LifecycleAware {
    private static final Logger log = Logger.getLogger(ReportsPluginLauncher.class);
    private final EventPublisher eventPublisher;
    private final StatsEventListeners statsEventListeners;
    private final StatsEventDatabaseShredder statsEventDatabaseShredder;

    @Autowired
    public ReportsPluginLauncher(EventPublisher eventPublisher, StatsEventListeners statsEventListeners, StatsEventDatabaseShredder statsEventDatabaseShredder) {
        this.eventPublisher = eventPublisher;
        this.statsEventListeners = statsEventListeners;
        this.statsEventDatabaseShredder = statsEventDatabaseShredder;
    }

    public void onStart() {
        log.info((Object)"Service Desk Report Plugin onStart()");
        this.tenantlessSetup();
        this.tenantedSetup();
    }

    public void onStop() {
        log.info((Object)"Service Desk Report Plugin spring context is stopping...");
        this.tenantedShutdown();
        this.tenantlessShutdown();
    }

    private void tenantlessSetup() {
        this.eventPublisher.register((Object)this.statsEventListeners);
        this.statsEventDatabaseShredder.registerJobRunner();
    }

    private void tenantedSetup() {
        this.statsEventDatabaseShredder.scheduleJob();
    }

    private void tenantlessShutdown() {
        this.statsEventDatabaseShredder.unregisterJobRunner();
        this.eventPublisher.unregister((Object)this.statsEventListeners);
    }

    private void tenantedShutdown() {
        this.statsEventDatabaseShredder.unscheduleJob();
    }
}

