/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.urlnormalization;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.servicedesk.project.internal.web.urlnormalization.SDUrlNormalization;
import com.google.common.collect.Lists;
import com.sun.jersey.api.uri.UriTemplate;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SDUrlNormalizationImpl
implements SDUrlNormalization {
    private static final String invalidCharacter = "/";
    private static final String PROJECT_PREFIX = "/projects/{projectKey}/{pagePath:.*}";
    private static final String ADMIN_PREFIX = "/servicedesk/admin/{projectKey}/{pagePath:.*}";
    private static final String PORTAL_ISSUE_KEY = "/servicedesk/customer/portal/{portalId}/{projectKey}-{pagePath:.*}";
    private static final String QUEUE_AGENT = "/projects/{projectKey}/queues/custom/{queueId}/{issueKey}-{pagePath:.*}";
    private static final String QUEUE_AGENT_ISSUE = "/projects/{projectKey}/queues/custom/{queueId}/{issueKey}";
    private static final String CUSTOMER_ROOT = "/servicedesk/customer";
    private static final String CUSTOMER_PORTALS_ROOT = "/servicedesk/customer/portals";
    private final IssueManager jiraIssueManager;
    private static final List<String> MATCHING_PREFIX = Lists.newArrayList((Object[])new String[]{"/projects/{projectKey}/{pagePath:.*}", "/servicedesk/admin/{projectKey}/{pagePath:.*}", "/servicedesk/customer/portal/{portalId}/{projectKey}-{pagePath:.*}", "/projects/{projectKey}/queues/custom/{queueId}/{issueKey}-{pagePath:.*}"});
    private static final List<String> KEY_SENSITIVE = Lists.newArrayList((Object[])new String[]{"projectKey", "issueKey"});

    @Autowired
    public SDUrlNormalizationImpl(IssueManager issueManager) {
        this.jiraIssueManager = issueManager;
    }

    @Override
    public Option<String> normalizeUrl(HttpServletRequest httpServletRequest) {
        return Option.option((Object)httpServletRequest).flatMap(request -> {
            if (this.isAjaxRequest((HttpServletRequest)request) || !this.isGetMethod((HttpServletRequest)request)) {
                return Option.none();
            }
            String servletPath = request.getServletPath();
            if (StringUtils.isEmpty((String)servletPath)) {
                return Option.none();
            }
            Option<String> normaliseServletPath = this.normaliseString(servletPath);
            normaliseServletPath = this.customerRootToCustomerPortals((String)normaliseServletPath.getOrElse((Object)servletPath));
            normaliseServletPath = this.getCurrentIssueUrl((String)normaliseServletPath.getOrElse((Object)servletPath));
            normaliseServletPath = this.normalizeCaseSensitive((String)normaliseServletPath.getOrElse((Object)servletPath));
            String queryString = request.getQueryString();
            Option<String> normalisedQuery = this.normaliseString(queryString);
            if (normalisedQuery.forall(query -> query.equals(queryString)) && normaliseServletPath.forall(path -> path.equals(servletPath))) {
                return Option.none();
            }
            String contextPath = (String)Option.option((Object)request.getContextPath()).getOrElse((Object)"");
            UriBuilder uriBuilder = UriBuilder.fromUri((String)(contextPath + (String)normaliseServletPath.getOrElse((Object)servletPath)));
            uriBuilder.replaceQuery((String)normalisedQuery.getOrElse((Object)queryString));
            return Option.some((Object)uriBuilder.build(new Object[0]).toString());
        });
    }

    private Option<String> customerRootToCustomerPortals(String origin) {
        UriTemplate customerRootTemplate = new UriTemplate(CUSTOMER_ROOT);
        if (customerRootTemplate.match((CharSequence)origin, new HashMap())) {
            return Option.some((Object)CUSTOMER_PORTALS_ROOT);
        }
        return Option.some((Object)origin);
    }

    private Option<String> getCurrentIssueUrl(String origin) {
        String normalizedCase = origin;
        UriTemplate uriTemplate = new UriTemplate(QUEUE_AGENT);
        UriTemplate uriAgentTemplate = new UriTemplate(QUEUE_AGENT_ISSUE);
        HashMap<String, String> params = new HashMap<String, String>();
        if (uriTemplate.match((CharSequence)origin, new HashMap()) && uriAgentTemplate.match((CharSequence)origin, params)) {
            MutableIssue issue;
            String issueKey = (String)params.get(KEY_SENSITIVE.get(1));
            if (!StringUtils.isEmpty((String)issueKey) && (issue = this.jiraIssueManager.getIssueObject(issueKey)) != null) {
                String key = issue.getKey();
                String projectKey = issue.getProjectObject().getKey();
                params.put(KEY_SENSITIVE.get(0), StringUtils.upperCase((String)projectKey));
                params.put(KEY_SENSITIVE.get(1), StringUtils.upperCase((String)key));
            }
            normalizedCase = uriAgentTemplate.createURI(params);
        }
        return Option.some((Object)normalizedCase);
    }

    private Option<String> normaliseString(String origin) {
        if (StringUtils.isBlank((String)origin)) {
            return Option.option((Object)origin);
        }
        String normaliseResult = StringUtils.stripEnd((String)origin, (String)invalidCharacter);
        return Option.some((Object)normaliseResult);
    }

    private Option<String> normalizeCaseSensitive(String requestUrl) {
        String normalizedCase = requestUrl;
        for (String prefix : MATCHING_PREFIX) {
            HashMap<String, String> params;
            UriTemplate uriTemplate = new UriTemplate(prefix);
            if (!uriTemplate.match((CharSequence)requestUrl, params = new HashMap<String, String>())) continue;
            for (String sensitiveCase : KEY_SENSITIVE) {
                String value = (String)params.get(sensitiveCase);
                if (StringUtils.isEmpty((String)value)) continue;
                params.put(sensitiveCase, StringUtils.upperCase((String)value));
            }
            normalizedCase = uriTemplate.createURI(params);
        }
        return Option.some((Object)normalizedCase);
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        return "XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"));
    }

    private boolean isGetMethod(HttpServletRequest request) {
        return "GET".equalsIgnoreCase(request.getMethod());
    }
}

