/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.sidebar.lastvisited;

import com.atlassian.fugue.Option;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.context.ProjectContextPopulator;
import com.atlassian.jira.projects.api.sidebar.lastvisited.LastVisitedNavigationItemProvider;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItem;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItemService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskLastVisitedNavigationItemProvider
implements LastVisitedNavigationItemProvider {
    private static final String SECONDARY_NAVIGATION_SECTION = "servicedesk.project.sidebar.navigation.secondary";
    private static final List<String> IGNORED_SD_SIDEBAR_ITEM_IDS = Collections.unmodifiableList(Arrays.asList("com.atlassian.servicedesk.project-ui:sd-project-sidebar-portal", "com.atlassian.servicedesk.project-ui:sd-project-sidebar-knowledge-base", "com.atlassian.servicedesk.project-ui:sd-project-sidebar-raise-request", "com.atlassian.servicedesk.project-ui:sd-project-sidebar-customer-channels"));
    @Autowired
    ProjectContextPopulator projectContextPopulator;
    @Autowired
    NavigationItemService navigationItemService;

    public Option<NavigationItem> getNavigationItemById(Project project, String navigationItemId) {
        Map context = this.projectContextPopulator.populateWithProject(project);
        List secondaryItems = this.navigationItemService.getItemsInSection(SECONDARY_NAVIGATION_SECTION, context);
        for (NavigationItem item : secondaryItems) {
            String itemId = item.getId();
            if (IGNORED_SD_SIDEBAR_ITEM_IDS.contains(itemId) || !itemId.equals(navigationItemId)) continue;
            return Option.some((Object)item);
        }
        return Option.none();
    }
}

