/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.sidebar;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItem;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItemService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskSidebarTertiaryNavContextProvider
implements ContextProvider {
    public static final String WEB_ITEM_SECTION = "servicedesk.project.sidebar.navigation.tertiary";
    public static final String SETTINGS_SIDEBAR_SECTION_KEY = "jira.project.sidebar.settings.navigation";
    private static final String SETTINGS_URL = "settingsUrl";
    @Autowired
    private NavigationItemService navigationItemService;
    @Autowired
    private ProjectUrlsProvider projectUrlsProvider;

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        HashMap newContext = Maps.newHashMap();
        newContext.putAll(context);
        ArrayList<NavigationItem> items = new ArrayList<NavigationItem>();
        items.addAll(this.navigationItemService.getItemsInSection(WEB_ITEM_SECTION, (Map)newContext));
        this.loadProjectSettingsSection(newContext, items);
        newContext.put("items", items);
        newContext.put("tierOne", true);
        newContext.put("id", "sidebar-tertiary-navigation-panel");
        return newContext;
    }

    private void loadProjectSettingsSection(Map<String, Object> context, List<NavigationItem> items) {
        Project project = (Project)context.get("project");
        if (project == null) {
            return;
        }
        ProjectUrls projectUrls = this.projectUrlsProvider.getUrls(project.getKey(), ProjectUrlsProvider.UrlMode.WITHOUT_CONTEXT);
        String adminUrl = projectUrls.requestTypeSettings().toASCIIString();
        context.put(SETTINGS_URL, adminUrl);
        items.addAll(this.navigationItemService.getItemsInSection(SETTINGS_SIDEBAR_SECTION_KEY, context));
    }
}

