/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.pagedata;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeSystemIconService;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContext;
import com.atlassian.servicedesk.project.internal.util.PluginHelper;
import com.atlassian.servicedesk.project.internal.web.pagedata.AjsDataProvider;
import com.atlassian.servicedesk.project.internal.web.pagedata.KbLinkDataProvider;
import com.atlassian.servicedesk.project.internal.web.pagedata.WebpackDataProvider;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredData;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectDataAssembler {
    private WebpackDataProvider webpackDataProvider;
    private AjsDataProvider ajsDataProvider;
    private KbLinkDataProvider kbLinkDataProvider;
    private PageBuilderService pageBuilderService;
    private RequestTypeSystemIconService systemIconService;

    @Autowired
    public ProjectDataAssembler(AjsDataProvider ajsDataProvider, KbLinkDataProvider kbLinkDataProvider, PageBuilderService pageBuilderService, RequestTypeSystemIconService systemIconService, WebpackDataProvider webpackDataProvider) {
        this.ajsDataProvider = ajsDataProvider;
        this.kbLinkDataProvider = kbLinkDataProvider;
        this.pageBuilderService = pageBuilderService;
        this.systemIconService = systemIconService;
        this.webpackDataProvider = webpackDataProvider;
    }

    public void assembleData(ServiceDeskProjectContext context) {
        RequiredData dataAssembler = this.pageBuilderService.assembler().data();
        dataAssembler.requireData("webpack-meta", this.jsonData(this.webpackDataProvider.getData()));
        dataAssembler.requireData("rt-icon-default", (Number)this.systemIconService.getDefaultIconID());
        dataAssembler.requireData("sd-kb-link", this.jsonData(this.kbLinkDataProvider.kbLinkData(context.getProject())));
        dataAssembler.requireData(PluginHelper.completeKeyFor("ajs-meta"), this.jsonData(this.ajsDataProvider.getData(context)));
    }

    private Jsonable jsonData(Map<String, Object> data) {
        return writer -> {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            objectMapper.writeValue(writer, (Object)data);
        };
    }
}

