/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.pagedata;

import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.api.util.ServiceDeskApplicationVersionUtil;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContext;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AjsDataProvider {
    private ProjectUrlsProvider projectUrlsProvider;
    private WebResourceUrlProvider webResourceUrlProvider;
    private HelpUrls helpUrls;
    private UserSearchService userSearchService;
    private ServiceDeskApplicationVersionUtil serviceDeskApplicationVersionUtil;

    @Autowired
    public AjsDataProvider(ProjectUrlsProvider projectUrlsProvider, WebResourceUrlProvider webResourceUrlProvider, HelpUrls helpUrls, UserSearchService userSearchService, ServiceDeskApplicationVersionUtil serviceDeskApplicationVersionUtil) {
        this.projectUrlsProvider = projectUrlsProvider;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.helpUrls = helpUrls;
        this.userSearchService = userSearchService;
        this.serviceDeskApplicationVersionUtil = serviceDeskApplicationVersionUtil;
    }

    public Map<String, Object> getData(ServiceDeskProjectContext context) {
        String projectKey = context.getProject().getKey();
        HelpUrl advanced_searchHelpUrl = this.helpUrls.getUrl("advanced_search");
        ProjectUrls projectUrls = this.projectUrlsProvider.getUrls(projectKey, ProjectUrlsProvider.UrlMode.RELATIVE);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("loggedInUser", context.getUser().fold(() -> "", ApplicationUser::getName));
        data.put("projectKey", projectKey);
        data.put("serviceDeskId", context.getServiceDesk().getId());
        data.put("advanced-search-help-title", advanced_searchHelpUrl.getTitle());
        data.put("advanced-search-help-url", advanced_searchHelpUrl.getUrl());
        data.put("baseUrl", this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE));
        data.put("projectBaseUrl", projectUrls.projectBase());
        data.put("projectSettingsBaseUrl", projectUrls.projectSettings());
        data.put("isAdmin", context.isAgentAdmin());
        data.put("canBrowseUsers", this.userSearchService.canPerformAjaxSearch((ApplicationUser)context.getUser().getOrNull()));
        data.put("projectId", context.getProject().getId());
        data.put("sdPluginVersion", this.serviceDeskApplicationVersionUtil.getServiceDeskApplicationVersion());
        data.put("isOnDemand", false);
        return data;
    }
}

