/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.filters;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.servicedesk.project.internal.routing.unlicensed.UnlicensedRoute;
import com.atlassian.servicedesk.project.internal.routing.unlicensed.UnlicensedRouteProvider;
import io.atlassian.fugue.Option;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnlicensedPageFilter
extends AbstractHttpFilter {
    private final UnlicensedRouteProvider unlicensedRouteProvider;

    @Autowired
    public UnlicensedPageFilter(UnlicensedRouteProvider unlicensedRouteProvider) {
        this.unlicensedRouteProvider = unlicensedRouteProvider;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Option<UnlicensedRoute> routeOption = this.getUnlicensedRouteSafe(request);
        if (routeOption.isDefined()) {
            UnlicensedRoute routeInfo = (UnlicensedRoute)routeOption.get();
            request.getRequestDispatcher(routeInfo.getTo()).forward((ServletRequest)request, (ServletResponse)response);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private Option<UnlicensedRoute> getUnlicensedRouteSafe(HttpServletRequest request) {
        try {
            return this.unlicensedRouteProvider.getRoute(request.getServletPath());
        }
        catch (RuntimeException e) {
            return Option.none();
        }
    }
}

