/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.filters;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.project.internal.routing.projecttype.ServiceDeskProjectTypeRoute;
import com.atlassian.servicedesk.project.internal.routing.projecttype.ServiceDeskProjectTypeRouteProvider;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedirectForSdProjects
extends AbstractHttpFilter {
    @Autowired
    private JiraAuthenticationContext authenticationContext;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private ServiceDeskProjectTypeRouteProvider routeMapping;

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        String path = request.getServletPath();
        String contextPath = request.getContextPath();
        Option<ServiceDeskProjectTypeRoute> potentialRoute = this.routeMapping.getRoute(path, request.getQueryString());
        Option userOption = Option.option((Object)user);
        if (potentialRoute.isDefined()) {
            ServiceDeskProjectTypeRoute route = (ServiceDeskProjectTypeRoute)potentialRoute.get();
            if (userOption.isDefined() || !route.isAuthenticated()) {
                request.getRequestDispatcher(route.getTo()).forward((ServletRequest)request, (ServletResponse)response);
            } else {
                String encodedTargetUri = URLEncoder.encode(route.getFrom(), this.applicationProperties.getEncoding());
                response.sendRedirect(contextPath + "/login.jsp?os_destination=" + encodedTargetUri);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

