/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.action;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.servicedesk.internal.api.eyeball.EyeballService;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.project.internal.soy.SoyRenderer;
import com.atlassian.servicedesk.project.internal.util.PluginHelper;
import com.atlassian.servicedesk.project.internal.web.action.ProjectActionSupport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredData;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnlicensedApplicationAction
extends ProjectActionSupport {
    private static final String PROJECT_ADMIN_DECORATOR = "projectAdmin";
    private static final String TEMPLATES = "ServiceDesk.Unlicensed.Templates.%s";
    private static final String WRM_DATA_KEY = PluginHelper.completeKeyFor("unlicensedRendererOptions");
    private final ProjectUrlsProvider projectUrlsProvider;
    private final HelpUrls helpUrls;
    private final JiraContactHelper jiraContactHelper;
    private final EventPublisher eventPublisher;
    private ProjectService projectService;
    private String decorator = "";
    private String projectKey;
    private String selectedItemId;

    @Autowired
    public UnlicensedApplicationAction(EyeballService eyeballService, SoyRenderer soyRenderer, PageBuilderService pageBuilderService, ProjectUrlsProvider projectUrlsProvider, HelpUrls helpUrls, JiraContactHelper jiraContactHelper, EventPublisher eventPublisher, ProjectService projectService) {
        super(eyeballService, soyRenderer, pageBuilderService);
        this.projectUrlsProvider = projectUrlsProvider;
        this.helpUrls = helpUrls;
        this.jiraContactHelper = jiraContactHelper;
        this.eventPublisher = eventPublisher;
        this.projectService = projectService;
    }

    public void setDecorator(String decorator) {
        this.decorator = decorator;
    }

    public void setSelectedItemId(String selectedItemId) {
        this.selectedItemId = selectedItemId;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String doView() {
        this.assembleRequiredResources();
        this.publishPageView();
        ProjectUrls projectUrls = this.projectUrlsProvider.getUrls(this.projectKey, ProjectUrlsProvider.UrlMode.RELATIVE);
        this.assembleRequiredData(projectUrls.issues());
        if (this.decorator.equals(PROJECT_ADMIN_DECORATOR)) {
            return this.renderForProjectAdmin();
        }
        return this.render();
    }

    private String renderForProjectAdmin() {
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKeyForAction(this.getLoggedInUser(), this.projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
        if (projectResult.isValid()) {
            Project project = projectResult.getProject();
            String templateAddress = String.format(TEMPLATES, "projectAdminPage");
            this.setSuccessfulForMau();
            this.renderSoy("com.atlassian.servicedesk.project-ui:soy", templateAddress, (Map<String, Object>)ImmutableMap.of((Object)"projectKey", (Object)project.getKey(), (Object)"projectId", (Object)project.getId(), (Object)"selectedItemId", (Object)this.selectedItemId));
            return null;
        }
        return "";
    }

    private String render() {
        this.renderSoy("com.atlassian.servicedesk.project-ui:soy", String.format(TEMPLATES, "page"));
        return null;
    }

    private void assembleRequiredData(URI destinationUrl) {
        RequiredData dataAssembler = this.getAssembler().data();
        dataAssembler.requireData(WRM_DATA_KEY, writer -> {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            HashMap<String, String> requiredData = new HashMap<String, String>();
            requiredData.put("applicationName", this.getI18nHelper().getText("sd.project.common.service.desk"));
            requiredData.put("projectTypesInfoUrl", this.helpUrls.getUrl("project.types.learn.more").getUrl());
            requiredData.put("requestLicenseUrl", this.getRequestLicenseUrl());
            requiredData.put("projectRedirectUrl", destinationUrl.toASCIIString());
            requiredData.put("projectErrorTitle", this.getI18nHelper().getText("sd.project.unlicensed.title"));
            requiredData.put("projectErrorContent", this.getI18nHelper().getText("sd.project.unlicensed.error"));
            objectMapper.writeValue(writer, requiredData);
        });
    }

    private void publishPageView() {
        this.eventPublisher.publish((Object)new ServiceDeskUnlicensedPageView());
    }

    private String getRequestLicenseUrl() {
        return this.jiraContactHelper.isAdministratorContactFormEnabled() ? this.jiraContactHelper.getAdministratorContactLink(this.getContextPath()) : "";
    }

    private void assembleRequiredResources() {
        RequiredResources resourceAssembler = this.getAssembler().resources();
        resourceAssembler.requireContext("sd.agent.unlicensed");
    }

    private String getContextPath() {
        return ExecutingHttpRequest.get().getContextPath();
    }

    @EventName(value="servicedesk.project.unlicensed.pageview")
    public class ServiceDeskUnlicensedPageView {
        @JsonCreator
        public ServiceDeskUnlicensedPageView() {
        }
    }
}

