/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.action;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.action.util.CalendarResourceIncluder;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.eyeball.EyeballService;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContext;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContextProvider;
import com.atlassian.servicedesk.project.internal.soy.SoyRenderer;
import com.atlassian.servicedesk.project.internal.web.action.ProjectActionSupport;
import com.atlassian.servicedesk.project.internal.web.action.ProjectPage;
import com.atlassian.servicedesk.project.internal.web.pagedata.ProjectDataAssembler;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.EnumSet;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectSettingsApplicationAction
extends ProjectActionSupport {
    private static final EnumSet<ProjectPage> CALENDAR_PAGES = EnumSet.of(ProjectPage.SLA, ProjectPage.REQUEST_TYPES, ProjectPage.AUTOMATION);
    private final ServiceDeskProjectContextProvider serviceDeskProjectContextProvider;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ErrorResultHelper errorHelper;
    private final ProjectDataAssembler projectDataAssembler;
    private Option<ProjectPage> page;

    @Autowired
    public ProjectSettingsApplicationAction(EyeballService eyeballService, SoyRenderer soyRenderer, PageBuilderService pageBuilderService, ServiceDeskProjectContextProvider serviceDeskProjectContextProvider, JiraAuthenticationContext jiraAuthenticationContext, ErrorResultHelper errorHelper, ProjectDataAssembler projectDataAssembler) {
        super(eyeballService, soyRenderer, pageBuilderService);
        this.serviceDeskProjectContextProvider = serviceDeskProjectContextProvider;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.errorHelper = errorHelper;
        this.projectDataAssembler = projectDataAssembler;
    }

    public void setPage(String path) {
        this.page = ProjectPage.fromPath(path);
    }

    public String doView() {
        if (this.page.isEmpty()) {
            return this.getRedirect(ProjectPage.REQUEST_TYPES.getPath());
        }
        ProjectPage currentPage = (ProjectPage)((Object)this.page.get());
        Either<AnError, ServiceDeskProjectContext> projectContextResult = this.serviceDeskProjectContextProvider.getContext(this.projectKey);
        if (projectContextResult.isLeft()) {
            this.renderError((AnError)projectContextResult.left().get());
            return null;
        }
        ServiceDeskProjectContext context = (ServiceDeskProjectContext)projectContextResult.right().get();
        if (!context.isAgentAdmin()) {
            AnError forbiddenError = this.errorHelper.forbidden403("sd.project.admin.no.permission", new Object[0]).build();
            this.renderError(forbiddenError);
            return null;
        }
        this.render(context, currentPage);
        return null;
    }

    private void render(ServiceDeskProjectContext context, ProjectPage currentPage) {
        this.assembleRequiredResources(currentPage);
        this.projectDataAssembler.assembleData(context);
        HashMap<String, Object> renderData = new HashMap<String, Object>();
        renderData.put("projectId", context.getProject().getId());
        renderData.put("projectKey", context.getProject().getKey());
        renderData.put("selectItemId", currentPage.getSidebarItemKey());
        this.setSuccessfulForMau();
        this.renderSoy("com.atlassian.servicedesk.project-ui:soy", "ServiceDesk.Project.Settings.Templates.page", renderData);
    }

    private void assembleRequiredResources(ProjectPage currentPage) {
        this.assembleRequiredResources(currentPage, "sd.project.admin", "sd.project.api");
        if (CALENDAR_PAGES.contains((Object)currentPage)) {
            ((CalendarResourceIncluder)ComponentAccessor.getComponent(CalendarResourceIncluder.class)).includeForLocale(this.jiraAuthenticationContext.getLocale());
        }
    }
}

