/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.util;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.servicedesk.project.internal.util.RedirectRule;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sun.jersey.api.uri.UriTemplate;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class RenaissanceRedirectMapping {
    @TenantAware(value=TenancyScope.TENANTLESS)
    private static final Map<String, String> GLOBAL_REDIRECT_MAPPINGS = ImmutableMap.of((Object)"/servicedesk/agent/all", (Object)"/secure/BrowseProjects.jspa?selectedCategory=all&selectedProjectType=service_desk");
    private static final RedirectRule SLA_REDIRECT_RULE = new RedirectRule(new UriTemplate("/servicedesk/agent/{projectKey}/sla"), new UriTemplate("/servicedesk/admin/{projectKey}/sla"), (Map<String, String>)ImmutableMap.of((Object)"/", (Object)"/custom/"));
    private static final RedirectRule PROJECT_REDIRECT_RULE = new RedirectRule(new UriTemplate("/servicedesk/agent/{projectKey}/"), new UriTemplate("/projects/{projectKey}/"), (Map<String, String>)ImmutableMap.of((Object)"people/agents", (Object)"reports/workload", (Object)"people/customers", (Object)"customers", (Object)"people/collaborators", (Object)"queues", (Object)"people", (Object)"customers"));
    private static final RedirectRule SETTING_AGENTS_REDIRECT_RULE = new RedirectRule(new UriTemplate("/servicedesk/agent/{projectKey}/settings/agents"), new UriTemplate("/projects/{projectKey}/reports/workload"));
    private static final RedirectRule SETTING_CUSTOMERS_REDIRECT_RULE = new RedirectRule(new UriTemplate("/servicedesk/agent/{projectKey}/settings/customers"), new UriTemplate("/projects/{projectKey}/customers"));
    private static final RedirectRule SETTING_REDIRECT_RULE = new RedirectRule(new UriTemplate("/servicedesk/agent/{projectKey}/settings/"), new UriTemplate("/servicedesk/admin/{projectKey}/"), (Map<String, String>)ImmutableMap.builder().put((Object)"requesttypes", (Object)"request-types").put((Object)"requestsecurity", (Object)"request-security").put((Object)"participants", (Object)"request-security").put((Object)"portal", (Object)"portal-settings").put((Object)"feedback", (Object)"feedback-settings").put((Object)"email", (Object)"email-settings").put((Object)"kb", (Object)"confluence-kb").put((Object)"collaborators", (Object)"request-types").put((Object)"sla/", (Object)"sla/custom/").build());
    private static final RedirectRule SETTING_ROOT_REDIRECT_RULE = new RedirectRule(new UriTemplate("/servicedesk/agent/{projectKey}/settings"), new UriTemplate("/servicedesk/admin/{projectKey}/request-types"));
    private static final List<RedirectRule> REDIRECT_RULES = Lists.newArrayList((Object[])new RedirectRule[]{SLA_REDIRECT_RULE, SETTING_AGENTS_REDIRECT_RULE, SETTING_CUSTOMERS_REDIRECT_RULE, SETTING_REDIRECT_RULE, SETTING_ROOT_REDIRECT_RULE, PROJECT_REDIRECT_RULE});

    public Option<String> getRedirectUrl(String url) {
        Option globalRedirectUrl = Option.option((Object)GLOBAL_REDIRECT_MAPPINGS.get(url));
        if (globalRedirectUrl.isDefined()) {
            return globalRedirectUrl;
        }
        for (RedirectRule redirectRule : REDIRECT_RULES) {
            Option<String> redirectUrl = redirectRule.getRedirectUrl(url);
            if (!redirectUrl.isDefined()) continue;
            return redirectUrl;
        }
        return Option.none();
    }
}

