/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.sla;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetricService;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.project.internal.util.PluginHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SlaItemProvider
implements WebItemProvider {
    private final JiraAuthenticationContext authenticationContext;
    private final TimeMetricService timeMetricService;
    private final ServiceDeskService serviceDeskService;
    private final ProjectUrlsProvider projectUrlProvider;

    @Autowired
    public SlaItemProvider(JiraAuthenticationContext authenticationContext, TimeMetricService timeMetricService, ServiceDeskService serviceDeskService, ProjectUrlsProvider projectUrlProvider) {
        this.authenticationContext = authenticationContext;
        this.timeMetricService = timeMetricService;
        this.serviceDeskService = serviceDeskService;
        this.projectUrlProvider = projectUrlProvider;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        ArrayList items = Lists.newArrayList();
        Project project = (Project)context.get("project");
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        io.atlassian.fugue.Either serviceDeskResult = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, project));
        if (!serviceDeskResult.isRight()) {
            return items;
        }
        io.atlassian.fugue.Either timeMetricsResult = StepsConverters.newerEither((Either)this.timeMetricService.getTimeMetrics(user, (ServiceDesk)serviceDeskResult.right().get()));
        if (!timeMetricsResult.isRight()) {
            return items;
        }
        Collection timeMetrics = (Collection)timeMetricsResult.right().get();
        ProjectUrls projectUrls = this.projectUrlProvider.getUrls(project.getKey(), ProjectUrlsProvider.UrlMode.RELATIVE);
        for (TimeMetric timeMetric : timeMetrics) {
            WebItem item = new WebFragmentBuilder(PluginHelper.completeKeyFor("sla-nav-" + timeMetric.getId()), 0).label(timeMetric.getName()).addParam("pageId", "custom").addParam("entityId", "" + timeMetric.getId()).webItem("").url(projectUrls.slaSettings(timeMetric.getId().toString()).toASCIIString()).build();
            items.add(item);
        }
        return items;
    }
}

