/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.rest;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.onboarding.OnBoardingPropertiesService;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.internal.api.project.PortalUrls;
import com.atlassian.servicedesk.internal.api.project.PortalUrlsProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContext;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContextProvider;
import com.atlassian.servicedesk.project.internal.rest.response.WelcomeGuideDataResponse;
import io.atlassian.fugue.Either;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/welcome-guide")
public class WelcomeGuideResource {
    private final ProjectUrlsProvider projectUrlProvider;
    private final OnBoardingPropertiesService onBoardingPropertiesService;
    private final JiraAuthenticationContext authenticationContext;
    private final ServiceDeskProjectContextProvider serviceDeskProjectContextProvider;
    private final PortalUrlsProvider portalUrlsProvider;
    private final PortalManager portalManager;

    @Autowired
    public WelcomeGuideResource(ProjectUrlsProvider projectUrlProvider, OnBoardingPropertiesService onBoardingPropertiesService, JiraAuthenticationContext authenticationContext, ServiceDeskProjectContextProvider serviceDeskProjectContextProvider, PortalUrlsProvider portalUrlsProvider, PortalManager portalManager) {
        this.projectUrlProvider = projectUrlProvider;
        this.onBoardingPropertiesService = onBoardingPropertiesService;
        this.authenticationContext = authenticationContext;
        this.serviceDeskProjectContextProvider = serviceDeskProjectContextProvider;
        this.portalUrlsProvider = portalUrlsProvider;
        this.portalManager = portalManager;
    }

    @GET
    @Path(value="/{projectKey}")
    public Response getWelcomeGuideData(@PathParam(value="projectKey") String projectKey) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        ProjectUrls projectUrls = this.projectUrlProvider.getUrls(projectKey, ProjectUrlsProvider.UrlMode.ABSOLUTE);
        PortalUrls portalUrls = this.portalUrlsProvider.getUrls(ProjectUrlsProvider.UrlMode.ABSOLUTE);
        Either portalByProjectKey = this.portalManager.getPortalByProjectKey(projectKey);
        if (portalByProjectKey.isRight()) {
            portalUrls = this.portalUrlsProvider.getUrls(((Portal)portalByProjectKey.right().get()).getId(), ProjectUrlsProvider.UrlMode.ABSOLUTE);
        }
        boolean shouldShowWelcomeGuide = this.shouldShowWelcomeGuide(user);
        boolean isAgentAdmin = false;
        boolean isAgent = false;
        ServiceDeskProjectContext context = (ServiceDeskProjectContext)this.serviceDeskProjectContextProvider.getContext(projectKey).getOrNull();
        if (context != null) {
            isAgentAdmin = context.isAgentAdmin();
            isAgent = context.isAgent();
        }
        return Response.ok((Object)new WelcomeGuideDataResponse(projectUrls, portalUrls, shouldShowWelcomeGuide, isAgentAdmin, isAgent, this.onBoardingPropertiesService.getCompletedChecklistItems(user))).build();
    }

    @POST
    @Path(value="/dismiss")
    public Response dismissWelcomeGuide() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user != null) {
            this.onBoardingPropertiesService.dismissWelcomeGuide(user);
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="/restore")
    public Response restoreWelcomeGuide() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user != null) {
            this.onBoardingPropertiesService.restoreWelcomeGuide(user);
        }
        return Response.noContent().build();
    }

    private boolean shouldShowWelcomeGuide(ApplicationUser user) {
        if (user != null) {
            return this.onBoardingPropertiesService.isWelcomeGuideDismissed(user) == false;
        }
        return false;
    }
}

