/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.requesttypes;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.requesttype.RequestTypeGroup;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupService;
import com.atlassian.servicedesk.project.internal.util.PluginHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupItemProvider
implements WebItemProvider {
    private final ProjectUrlsProvider projectUrlProvider;
    private final RequestTypeGroupService groupService;
    private final PortalService portalService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public GroupItemProvider(ProjectUrlsProvider projectUrlProvider, RequestTypeGroupService groupService, PortalService portalService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.projectUrlProvider = projectUrlProvider;
        this.groupService = groupService;
        this.portalService = portalService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        ArrayList items = Lists.newArrayList();
        Project project = (Project)context.get("project");
        if (project == null) {
            return items;
        }
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (user == null) {
            return items;
        }
        io.atlassian.fugue.Either groupsResult = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.portalService.getPortalForProject(user, project))).then(portal -> this.groupService.getGroups(user, project, portal)).yield((portal, groups) -> groups);
        if (groupsResult.isLeft()) {
            return items;
        }
        ProjectUrls projectUrls = this.projectUrlProvider.getUrls(project.getKey(), ProjectUrlsProvider.UrlMode.RELATIVE);
        List requestTypeGroups = (List)groupsResult.right().get();
        int weight = 100;
        for (RequestTypeGroup requestTypeGroup : requestTypeGroups) {
            WebItem item = new WebFragmentBuilder(PluginHelper.completeKeyFor("request-type-nav-" + requestTypeGroup.getId()), weight).label(requestTypeGroup.getName()).addParam("pageId", "group").addParam("entityId", "" + requestTypeGroup.getId()).webItem("").url(projectUrls.requestTypeSettings(String.valueOf(requestTypeGroup.getId())).toASCIIString()).build();
            items.add(item);
            weight += 100;
        }
        return items;
    }
}

