/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.queues;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Either;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.queue.Queue;
import com.atlassian.servicedesk.api.queue.QueueQuery;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.api.util.paging.SimplePagedRequest;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.api.queues.CustomQueueCountState;
import com.atlassian.servicedesk.internal.api.queues.CustomQueueSettingsService;
import com.atlassian.servicedesk.internal.api.queues.InternalQueueService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomQueuesItemProvider
implements WebItemProvider {
    private final InternalQueueService internalQueueService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectUrlsProvider projectUrlsProvider;
    private final EventPublisher eventPublisher;
    private final CustomQueueSettingsService customQueueSettingsService;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;

    @Autowired
    public CustomQueuesItemProvider(InternalQueueService internalQueueService, JiraAuthenticationContext jiraAuthenticationContext, ProjectUrlsProvider projectUrlsProvider, EventPublisher eventPublisher, CustomQueueSettingsService customQueueSettingsService, InternalServiceDeskProjectManager internalServiceDeskProjectManager) {
        this.internalQueueService = internalQueueService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectUrlsProvider = projectUrlsProvider;
        this.eventPublisher = eventPublisher;
        this.customQueueSettingsService = customQueueSettingsService;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
    }

    public Iterable<WebItem> getItems(Map<String, Object> map) {
        int serviceDeskId = (Integer)map.get("serviceDeskId");
        String projectKey = (String)map.get("projectKey");
        io.atlassian.fugue.Either<AnError, List<Queue>> queuesEither = this.getQueues(projectKey, serviceDeskId, this.internalQueueService.getQueueLimitForProject());
        ProjectUrls projectUrls = this.projectUrlsProvider.getUrls(projectKey, ProjectUrlsProvider.UrlMode.RELATIVE);
        if (queuesEither.isRight()) {
            QueueSubNavRequestedEvent event = new QueueSubNavRequestedEvent(serviceDeskId, ((List)queuesEither.right().get()).size());
            this.eventPublisher.publish((Object)event);
        }
        return (Iterable)queuesEither.fold(error -> ImmutableList.of(), queues -> queues.stream().map(queue -> new WebFragmentBuilder(Objects.toString(queue.getId()), 0).label(queue.getName()).addParam("entityId", Objects.toString(queue.getId())).addParam("pageId", "custom").addParam("count", queue.getIssueCount().map(Objects::toString).orElse("")).webItem("").url(projectUrls.customQueue(Objects.toString(queue.getId())).toASCIIString()).build()).collect(Collectors.toList()));
    }

    @VisibleForTesting
    io.atlassian.fugue.Either<AnError, List<Queue>> getQueues(String projectKey, int serviceDeskId, int count) {
        CustomQueueCountState customQueueCountStateForProject = (CustomQueueCountState)this.internalServiceDeskProjectManager.getProjectByKey(projectKey).flatMap(project -> io.atlassian.fugue.Either.right((Object)this.customQueueSettingsService.getCustomQueueCountState(project))).getOr(() -> CustomQueueSettingsService.DEFAULT_CUSTOM_QUEUE_COUNT_STATE);
        int queuesPerPage = 50;
        boolean hasNextPage = true;
        ArrayList queues = new ArrayList();
        while (hasNextPage && queues.size() < count) {
            QueueQuery queueQuery = this.internalQueueService.newQueueQueryBuilder().serviceDeskId((long)serviceDeskId).includeIssueCount(customQueueCountStateForProject.isInclude()).pagedRequest((PagedRequest)new SimplePagedRequest(queues.size(), queuesPerPage)).build();
            io.atlassian.fugue.Either responseEither = customQueueCountStateForProject.isUseCache() ? this.internalQueueService.getQueuesWithCachedCount(this.jiraAuthenticationContext.getLoggedInUser(), queueQuery) : StepsConverters.newerEither((Either)this.internalQueueService.getQueues(this.jiraAuthenticationContext.getLoggedInUser(), queueQuery));
            if (responseEither.isLeft()) {
                return io.atlassian.fugue.Either.left((Object)responseEither.left().get());
            }
            PagedResponse response = (PagedResponse)responseEither.right().get();
            queues.addAll(response.getResults());
            hasNextPage = response.hasNextPage();
        }
        return io.atlassian.fugue.Either.right(queues);
    }

    @EventName(value="servicedesk.agentview.queue.subnav.requested")
    @VisibleForTesting
    static class QueueSubNavRequestedEvent
    extends AnalyticsEvent {
        private final Integer serviceDeskId;
        private final Integer queueCount;

        QueueSubNavRequestedEvent(Integer serviceDeskId, Integer queueCount) {
            this.serviceDeskId = serviceDeskId;
            this.queueCount = queueCount;
        }

        public Integer getServiceDeskId() {
            return this.serviceDeskId;
        }

        public Integer getQueueCount() {
            return this.queueCount;
        }
    }
}

