/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.queues;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.queues.CustomQueueCountState;
import com.atlassian.servicedesk.internal.api.queues.CustomQueueSettingsService;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.project.internal.queues.CustomQueueSettingsManager;
import io.atlassian.fugue.Either;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@ExportAsService
@Component
public class CustomQueueSettingsServiceImpl
implements CustomQueueSettingsService {
    private final CustomQueueSettingsManager customQueueSettingsManager;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final CommonErrors commonErrors;

    @Autowired
    public CustomQueueSettingsServiceImpl(CustomQueueSettingsManager customQueueSettingsManager, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, CommonErrors commonErrors) {
        this.customQueueSettingsManager = customQueueSettingsManager;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.commonErrors = commonErrors;
    }

    public Either<AnError, Boolean> setCustomQueueIncludeCountGlobally(CheckedUser user, boolean customQueueIncludeCount) {
        if (!this.serviceDeskLicenseAndPermissionService.canAdministerJIRA((SDUser)user)) {
            return Either.left((Object)this.commonErrors.JIRA_ADMIN_PERMISSION_ERROR());
        }
        return this.customQueueSettingsManager.setCustomQueueIncludeCountGlobally(customQueueIncludeCount);
    }

    public Either<AnError, Boolean> setCustomQueueIncludeCountProject(CheckedUser user, Project project, boolean customQueueIncludeCount) {
        if (!this.serviceDeskLicenseAndPermissionService.canAdministerJIRA((SDUser)user) && !this.serviceDeskLicenseAndPermissionService.canAdministerServiceDesk((SDUser)user, project)) {
            return Either.left((Object)this.commonErrors.ADMINISTER_PERMISSIONS_ERROR());
        }
        return this.customQueueSettingsManager.setCustomQueueIncludeCountProject(project, customQueueIncludeCount);
    }

    public Either<AnError, Boolean> setCustomQueueUseLazyCachedCountGlobally(CheckedUser user, boolean customQueueIncludeCount) {
        if (!this.serviceDeskLicenseAndPermissionService.canAdministerJIRA((SDUser)user)) {
            return Either.left((Object)this.commonErrors.JIRA_ADMIN_PERMISSION_ERROR());
        }
        return this.customQueueSettingsManager.setCustomQueueUseLazyCachedCountGlobally(customQueueIncludeCount);
    }

    public Either<AnError, Boolean> setCustomQueueUseLazyCachedCountProject(CheckedUser user, Project project, boolean customQueueIncludeCount) {
        if (!this.serviceDeskLicenseAndPermissionService.canAdministerJIRA((SDUser)user) && !this.serviceDeskLicenseAndPermissionService.canAdministerServiceDesk((SDUser)user, project)) {
            return Either.left((Object)this.commonErrors.ADMINISTER_PERMISSIONS_ERROR());
        }
        return this.customQueueSettingsManager.setCustomQueueUseLazyCachedCountProject(project, customQueueIncludeCount);
    }

    public CustomQueueCountState getCustomQueueCountState(Project project) {
        boolean includeCountGlobally = this.customQueueSettingsManager.isCustomQueueIncludeCountGlobally();
        boolean includeCountProject = this.customQueueSettingsManager.isCustomQueueIncludeCountProject(project);
        boolean cachedCountGlobally = this.customQueueSettingsManager.isCustomQueueUseLazyCachedCountGlobally();
        boolean cachedCountProject = this.customQueueSettingsManager.isCustomQueueUseLazyCachedCountProject(project);
        boolean include = includeCountGlobally && includeCountProject;
        boolean cache = cachedCountGlobally && cachedCountProject;
        return CustomQueueCountState.findCustomQueueCountState((boolean)include, (boolean)cache);
    }
}

