/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.queues;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomQueueSettingsManager {
    private static final Logger log = LoggerFactory.getLogger(CustomQueueSettingsManager.class);
    private static final boolean INCLUDE_QUEUE_COUNT_DEFAULT = true;
    private static final boolean CACHED_QUEUE_COUNT_DEFAULT = false;
    @VisibleForTesting
    static final String INCLUDE_QUEUE_COUNT_PROPERTY_KEY = "custom.queue.include.queue.count.globally";
    @VisibleForTesting
    static final String INCLUDE_QUEUE_COUNT_PROPERTY_PROJECT_PREFIX_KEY = "custom.queue.include.queue.count.";
    @VisibleForTesting
    static final String CACHED_QUEUE_COUNT_PROPERTY_KEY = "custom.queue.cached.queue.count.globally";
    @VisibleForTesting
    static final String CACHED_QUEUE_COUNT_PROPERTY_PROJECT_PREFIX_KEY = "custom.queue.cached.include.queue.count.";
    private final GlobalPropertyDao globalPropertyDao;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public CustomQueueSettingsManager(GlobalPropertyDao globalPropertyDao, ErrorResultHelper errorResultHelper) {
        this.globalPropertyDao = globalPropertyDao;
        this.errorResultHelper = errorResultHelper;
    }

    public boolean isCustomQueueIncludeCountGlobally() {
        return (Boolean)Option.option((Object)this.globalPropertyDao.getBooleanProperty(INCLUDE_QUEUE_COUNT_PROPERTY_KEY)).fold(() -> {
            log.debug("The {} global property has failed to be read. Fall back to default of {}", (Object)INCLUDE_QUEUE_COUNT_PROPERTY_KEY, (Object)true);
            return true;
        }, Function.identity());
    }

    public Either<AnError, Boolean> setCustomQueueIncludeCountGlobally(boolean customQueueIncludeCount) {
        this.globalPropertyDao.setBooleanProperty(INCLUDE_QUEUE_COUNT_PROPERTY_KEY, Boolean.valueOf(customQueueIncludeCount));
        boolean actualCustomQueueIncludeCount = this.isCustomQueueIncludeCountGlobally();
        if (actualCustomQueueIncludeCount != customQueueIncludeCount) {
            log.warn("The {} global property has failed to be updated.", (Object)INCLUDE_QUEUE_COUNT_PROPERTY_KEY);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.agent.queue.custom.include.count.set.error", new Object[0]).build());
        }
        return Either.right((Object)actualCustomQueueIncludeCount);
    }

    public boolean isCustomQueueIncludeCountProject(Project project) {
        String propertyKey = CustomQueueSettingsManager.getIncludeQueueCountPropertyProjectKey(project);
        return (Boolean)Option.option((Object)this.globalPropertyDao.getBooleanProperty(propertyKey)).fold(() -> {
            log.debug("The {} global property has failed to be read. Fall back to default of {}", (Object)propertyKey, (Object)true);
            return true;
        }, Function.identity());
    }

    public Either<AnError, Boolean> setCustomQueueIncludeCountProject(Project project, boolean customQueueIncludeCount) {
        String propertyKey = CustomQueueSettingsManager.getIncludeQueueCountPropertyProjectKey(project);
        this.globalPropertyDao.setBooleanProperty(propertyKey, Boolean.valueOf(customQueueIncludeCount));
        boolean actualCustomQueueIncludeCount = this.isCustomQueueIncludeCountProject(project);
        if (actualCustomQueueIncludeCount != customQueueIncludeCount) {
            log.warn("The {} global property has failed to be updated.", (Object)propertyKey);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.agent.queue.custom.include.count.project.set.error", new Object[]{project.getKey()}).build());
        }
        return Either.right((Object)actualCustomQueueIncludeCount);
    }

    public boolean isCustomQueueUseLazyCachedCountGlobally() {
        return (Boolean)Option.option((Object)this.globalPropertyDao.getBooleanProperty(CACHED_QUEUE_COUNT_PROPERTY_KEY)).fold(() -> {
            log.debug("The {} global property has failed to be read. Fall back to default of {}", (Object)CACHED_QUEUE_COUNT_PROPERTY_KEY, (Object)false);
            return false;
        }, Function.identity());
    }

    public Either<AnError, Boolean> setCustomQueueUseLazyCachedCountGlobally(boolean customQueueCachedCount) {
        this.globalPropertyDao.setBooleanProperty(CACHED_QUEUE_COUNT_PROPERTY_KEY, Boolean.valueOf(customQueueCachedCount));
        boolean actualCustomQueueUseLazyCachedCountGlobally = this.isCustomQueueUseLazyCachedCountGlobally();
        if (actualCustomQueueUseLazyCachedCountGlobally != customQueueCachedCount) {
            log.warn("The {} global property has failed to be updated.", (Object)CACHED_QUEUE_COUNT_PROPERTY_KEY);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.agent.queue.custom.cached.count.set.error", new Object[0]).build());
        }
        return Either.right((Object)actualCustomQueueUseLazyCachedCountGlobally);
    }

    public boolean isCustomQueueUseLazyCachedCountProject(Project project) {
        String propertyKey = CustomQueueSettingsManager.getCachedQueueCountPropertyProjectKey(project);
        return (Boolean)Option.option((Object)this.globalPropertyDao.getBooleanProperty(propertyKey)).fold(() -> {
            log.debug("The {} global property has failed to be read. Fall back to default of {}", (Object)propertyKey, (Object)false);
            return false;
        }, Function.identity());
    }

    public Either<AnError, Boolean> setCustomQueueUseLazyCachedCountProject(Project project, boolean customQueueCachedCount) {
        String propertyKey = CustomQueueSettingsManager.getCachedQueueCountPropertyProjectKey(project);
        this.globalPropertyDao.setBooleanProperty(propertyKey, Boolean.valueOf(customQueueCachedCount));
        boolean actualCustomQueueUseLazyCachedCountGlobally = this.isCustomQueueUseLazyCachedCountProject(project);
        if (actualCustomQueueUseLazyCachedCountGlobally != customQueueCachedCount) {
            log.warn("The {} global property has failed to be updated.", (Object)propertyKey);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.agent.queue.custom.cached.count.project.set.error", new Object[]{project.getKey()}).build());
        }
        return Either.right((Object)actualCustomQueueUseLazyCachedCountGlobally);
    }

    private static String getIncludeQueueCountPropertyProjectKey(Project project) {
        return INCLUDE_QUEUE_COUNT_PROPERTY_PROJECT_PREFIX_KEY + project.getId();
    }

    private static String getCachedQueueCountPropertyProjectKey(Project project) {
        return CACHED_QUEUE_COUNT_PROPERTY_PROJECT_PREFIX_KEY + project.getId();
    }
}

