/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.condition;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetricService;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.api.sla.goal.GoalService;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class SlaReportCondition
implements Condition {
    @Autowired
    TimeMetricService timeMetricService;
    @Autowired
    GoalService goalService;

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> map) {
        ServiceDesk serviceDesk;
        ApplicationUser user = (ApplicationUser)map.get("user");
        io.atlassian.fugue.Either timeMetricsEither = StepsConverters.newerEither((Either)this.timeMetricService.getTimeMetrics(user, serviceDesk = (ServiceDesk)map.get("serviceDesk")));
        if (timeMetricsEither.isLeft()) {
            return false;
        }
        Collection timeMetrics = (Collection)timeMetricsEither.right().get();
        for (TimeMetric timeMetric : timeMetrics) {
            Collection goals = this.goalService.getGoals(user, serviceDesk, timeMetric);
            for (Goal goal : goals) {
                if (!goal.hasDuration()) continue;
                return true;
            }
        }
        return false;
    }
}

