/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.condition;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseService;
import com.atlassian.servicedesk.project.internal.util.ConditionHelper;
import io.atlassian.fugue.Option;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ShowKnowledgeBasePrimaryNavCondition
implements Condition {
    private final FeatureManager featureManager;
    private final ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService;
    private final ConditionHelper conditionHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public ShowKnowledgeBasePrimaryNavCondition(FeatureManager featureManager, ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService, ConditionHelper conditionHelper, JiraAuthenticationContext jiraAuthenticationContext) {
        this.featureManager = featureManager;
        this.confluenceKnowledgeBaseService = confluenceKnowledgeBaseService;
        this.conditionHelper = conditionHelper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> map) {
        if (!this.featureManager.isEnabled("sd.kb.primary.nav")) {
            return false;
        }
        boolean isConfluenceLinked = this.conditionHelper.isAtLeastOneConfluenceApplicationLinked(map);
        if (!isConfluenceLinked) {
            return false;
        }
        boolean isAdminAgent = this.conditionHelper.isAgentAdmin(map);
        if (isAdminAgent) {
            return true;
        }
        return (Boolean)Steps.begin((Option)Option.option((Object)map.get("project")).map(obj -> (Project)obj)).then(project -> Option.option((Object)this.jiraAuthenticationContext.getLoggedInUser())).then((project, user) -> this.confluenceKnowledgeBaseService.getKBLink(user, project).toOption()).yield((project, user, kbLink) -> this.conditionHelper.isAgent(map)).getOrElse((Object)false);
    }
}

