/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.condition;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgentAccessCondition
implements Condition {
    @Autowired
    private ServiceDeskPermissionService serviceDeskPermissionService;
    @Autowired
    private ServiceDeskService serviceDeskService;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> map) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        Object projectObj = map.get("project");
        if (projectObj == null || user == null) {
            return false;
        }
        Project project = (Project)projectObj;
        io.atlassian.fugue.Either serviceDeskForProjectEither = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, project));
        if (serviceDeskForProjectEither.isLeft()) {
            return false;
        }
        ServiceDesk serviceDesk = (ServiceDesk)serviceDeskForProjectEither.right().get();
        io.atlassian.fugue.Either isAgentEither = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(user, serviceDesk));
        if (isAgentEither.isLeft()) {
            return false;
        }
        return (Boolean)isAgentEither.right().get();
    }
}

