/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.bootstrap.version;

import com.atlassian.servicedesk.project.internal.bootstrap.version.BuildProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

@Component
public class BuildPropertiesImpl
implements BuildProperties {
    private Properties properties = this.loadProperties();

    private static String getPropertiesFileLocation() {
        Class<BuildPropertiesImpl> thisClass = BuildPropertiesImpl.class;
        return "/" + thisClass.getCanonicalName().replaceAll("\\.", "/").replaceFirst(thisClass.getSimpleName(), "BuildProperties.properties");
    }

    private Properties loadProperties() {
        InputStream stream = this.getClass().getResourceAsStream(BuildPropertiesImpl.getPropertiesFileLocation());
        if (stream == null) {
            throw new IllegalStateException("Failed to load BuildProperties.  We have a serious build issue");
        }
        try {
            Properties props = new Properties();
            props.load(stream);
            return props;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load BuildProperties.  We have a serious build issue");
        }
    }

    @Override
    public String getVersion() {
        return this.getRequired(this.properties, "plugin-info.version");
    }

    @Override
    public DateTime getBuildDate() {
        return new DateTime((Object)this.getRequired(this.properties, "plugin-info.build.date"));
    }

    @Override
    public String getChangeSet() {
        return this.getOptional(this.properties, "plugin-info.changeset", "DevVersion");
    }

    private String getRequired(Properties properties, String key) {
        String property = properties.getProperty(key);
        if (property == null) {
            throw new IllegalStateException("Unable to load a BuildProperty: " + key + ".  We have a serious build issue");
        }
        return property;
    }

    private String getOptional(Properties properties, String key, String defaultValue) {
        String property = properties.getProperty(key);
        if (property == null) {
            return defaultValue;
        }
        return property;
    }
}

