/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.bootstrap.lifecycle;

import com.atlassian.jira.projects.api.sidebar.content.ProjectContentRenderer;
import com.atlassian.jira.projects.api.sidebar.content.ProjectContentRendererRegistry;
import com.atlassian.jira.projects.api.sidebar.lastvisited.LastVisitedNavigationItemProvider;
import com.atlassian.jira.projects.api.sidebar.lastvisited.LastVisitedNavigationItemProviderRegistry;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.servicedesk.internal.api.project.type.ServiceDeskProjectType;
import com.atlassian.servicedesk.project.internal.web.sidebar.ServiceDeskSidebarContentRenderer;
import com.atlassian.servicedesk.project.internal.web.sidebar.lastvisited.ServiceDeskLastVisitedNavigationItemProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ProjectUIPluginLauncher
implements LifecycleAware {
    private final ProjectContentRendererRegistry projectContentRendererRegistry;
    private final LastVisitedNavigationItemProviderRegistry lastVisitedNavigationItemProviderRegistry;
    private final ServiceDeskSidebarContentRenderer serviceDeskSidebarContentRenderer;
    private final ServiceDeskLastVisitedNavigationItemProvider serviceDeskLastVisitedNavigationItemProvider;

    @Autowired
    public ProjectUIPluginLauncher(ProjectContentRendererRegistry projectContentRendererRegistry, LastVisitedNavigationItemProviderRegistry lastVisitedNavigationItemProviderRegistry, ServiceDeskSidebarContentRenderer serviceDeskSidebarContentRenderer, ServiceDeskLastVisitedNavigationItemProvider serviceDeskLastVisitedNavigationItemProvider) {
        this.projectContentRendererRegistry = projectContentRendererRegistry;
        this.lastVisitedNavigationItemProviderRegistry = lastVisitedNavigationItemProviderRegistry;
        this.serviceDeskSidebarContentRenderer = serviceDeskSidebarContentRenderer;
        this.serviceDeskLastVisitedNavigationItemProvider = serviceDeskLastVisitedNavigationItemProvider;
    }

    public void onStart() {
        this.tenantlessSetup();
    }

    public void onStop() {
        this.tenantlessShutdown();
    }

    private void tenantlessSetup() {
        this.projectContentRendererRegistry.register(ServiceDeskProjectType.KEY, (ProjectContentRenderer)this.serviceDeskSidebarContentRenderer);
        this.lastVisitedNavigationItemProviderRegistry.register(ServiceDeskProjectType.KEY, (LastVisitedNavigationItemProvider)this.serviceDeskLastVisitedNavigationItemProvider);
    }

    private void tenantlessShutdown() {
        this.lastVisitedNavigationItemProviderRegistry.unregister(ServiceDeskProjectType.KEY);
        this.projectContentRendererRegistry.unregister(ServiceDeskProjectType.KEY);
    }
}

