/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.issue;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.permission.security.CustomerInvolvedService;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.issue.RequestSharedWithListHelper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
class UserSharedWithListBuilder {
    private static final String USERS_SHARED_WITH_TRUNCATED_NAMES = "sd.notifications.footer.people.shared.with.number.truncated";
    private static final List<String> PREVIEW_USER_NAMES = ImmutableList.of((Object)"Brett Kennedy", (Object)"Rey Jakku", (Object)"Finn 2187");
    private final CustomerInvolvedService customerInvolvedService;
    private final RequestSharedWithListHelper requestSharedWithListHelper;

    @Autowired
    UserSharedWithListBuilder(CustomerInvolvedService customerInvolvedService, RequestSharedWithListHelper requestSharedWithListHelper) {
        this.customerInvolvedService = customerInvolvedService;
        this.requestSharedWithListHelper = requestSharedWithListHelper;
    }

    List<String> buildSharedWithList(ApplicationUser applicationUser, Issue issue) {
        List<String> eligibleDisplayNames = this.getSharedWithDisplayNames(issue);
        return this.requestSharedWithListHelper.buildSharedWithList(applicationUser, eligibleDisplayNames, USERS_SHARED_WITH_TRUNCATED_NAMES);
    }

    List<String> buildPreviewSharedWithList(ApplicationUser applicationUser) {
        return this.requestSharedWithListHelper.buildSharedWithList(applicationUser, PREVIEW_USER_NAMES, USERS_SHARED_WITH_TRUNCATED_NAMES);
    }

    private List<String> getSharedWithDisplayNames(Issue issue) {
        return Stream.concat(this.customerInvolvedService.getMembersForTypes(issue, new CustomerInvolvedType[]{CustomerInvolvedType.REPORTER}).stream(), this.customerInvolvedService.getMembersForTypes(issue, new CustomerInvolvedType[]{CustomerInvolvedType.REQUEST_PARTICIPANT}).stream()).distinct().map(CheckedUser::getDisplayName).collect(Collectors.toList());
    }
}

