/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.issue;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.issue.OrganisationSharedWithListBuilder;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.issue.UserSharedWithListBuilder;
import io.atlassian.fugue.Either;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestSharedWithRenderer
implements VariableRenderer {
    private static final String SHARED_WITH_LIST_I18N_KEY = "sd.notifications.footer.shared.with.long.list";
    private static final String SHARED_WITH_PAIR_I18N_KEY = "sd.notifications.footer.shared.with.pair";
    private final ErrorResultHelper errorResultHelper;
    private final FeatureManager featureManager;
    private final OrganisationSharedWithListBuilder organisationSharedWithTextBuilder;
    private final UserSharedWithListBuilder userSharedWithTextBuilder;
    private final I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public RequestSharedWithRenderer(ErrorResultHelper errorResultHelper, FeatureManager featureManager, OrganisationSharedWithListBuilder organisationSharedWithTextBuilder, UserSharedWithListBuilder userSharedWithTextBuilder, I18nHelper.BeanFactory i18nFactory) {
        this.errorResultHelper = errorResultHelper;
        this.featureManager = featureManager;
        this.organisationSharedWithTextBuilder = organisationSharedWithTextBuilder;
        this.userSharedWithTextBuilder = userSharedWithTextBuilder;
        this.i18nFactory = i18nFactory;
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        Either requestSharedWith = context.getIssue().toRight(() -> this.errorResultHelper.internalServiceError500("sd.notifications.base.content.issue.context.missing", new Object[]{context.getVariableContext().getNotificationVariable().getVariable()}).build()).map(issue -> this.renderRequestSharedWith(context.getRecipient(), (Issue)issue));
        if (NotificationRenderFormat.HTML.equals((Object)context.getNotificationRenderFormat())) {
            requestSharedWith = requestSharedWith.map(StringEscapeUtils::escapeHtml);
        }
        return requestSharedWith;
    }

    @Override
    public Either<AnError, String> renderPreview(VariableContext variableContext, NotificationPreviewContext previewContext) {
        ApplicationUser previewUser = previewContext.getPreviewingUser().forJIRA();
        List<String> userPreviewList = this.userSharedWithTextBuilder.buildPreviewSharedWithList(previewUser);
        if (!this.featureManager.isEnabled("sd.customer.orgs.group.participants")) {
            return Either.right((Object)this.buildSharedWithListForRecipient(previewUser, userPreviewList));
        }
        List<String> organisationPreviewList = this.organisationSharedWithTextBuilder.buildPreviewSharedWithList(previewUser);
        List<String> combinedPreviewList = Stream.concat(organisationPreviewList.stream(), userPreviewList.stream()).collect(Collectors.toList());
        return Either.right((Object)this.buildSharedWithListForRecipient(previewUser, combinedPreviewList));
    }

    public String renderRequestSharedWith(ApplicationUser recipient, Issue issue) {
        List<String> organisationSharedWithText = this.getOrganisationSharedWithText(recipient, issue);
        List<String> userSharedWithText = this.getUserSharedWithText(recipient, issue);
        List<String> combinedSharedWith = Stream.concat(organisationSharedWithText.stream(), userSharedWithText.stream()).collect(Collectors.toList());
        return this.buildSharedWithListForRecipient(recipient, combinedSharedWith);
    }

    private String buildSharedWithListForRecipient(ApplicationUser recipient, List<String> sharedWith) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(recipient);
        return this.stringifySharedWithList(i18nHelper, sharedWith);
    }

    private String stringifySharedWithList(I18nHelper i18nHelper, List<String> sharedWith) {
        if (sharedWith.isEmpty()) {
            return "";
        }
        if (sharedWith.size() == 1) {
            return sharedWith.get(0);
        }
        if (sharedWith.size() == 2) {
            return i18nHelper.getText(SHARED_WITH_PAIR_I18N_KEY, sharedWith.get(0), sharedWith.get(1));
        }
        String commaSeparatedRecipients = this.allButLastAsCommaSeparatedString(sharedWith);
        return i18nHelper.getText(SHARED_WITH_LIST_I18N_KEY, commaSeparatedRecipients, sharedWith.get(sharedWith.size() - 1));
    }

    private String allButLastAsCommaSeparatedString(List<String> sharedWith) {
        List<String> allButLast = sharedWith.subList(0, sharedWith.size() - 1);
        return StringUtils.join(allButLast, (String)", ");
    }

    private List<String> getOrganisationSharedWithText(ApplicationUser recipient, Issue issue) {
        if (this.featureManager.isEnabled("sd.customer.orgs.group.participants")) {
            return this.organisationSharedWithTextBuilder.buildSharedWithList(recipient, issue);
        }
        return Collections.emptyList();
    }

    private List<String> getUserSharedWithText(ApplicationUser recipient, Issue issue) {
        return this.userSharedWithTextBuilder.buildSharedWithList(recipient, issue);
    }
}

