/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.issue;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
class RequestSharedWithListHelper {
    private static final int REQUEST_SHARED_WITH_ENTRY_LIMIT = 4;
    private final I18nHelper.BeanFactory i18nFactory;

    @Autowired
    RequestSharedWithListHelper(I18nHelper.BeanFactory i18nFactory) {
        this.i18nFactory = i18nFactory;
    }

    List<String> buildSharedWithList(ApplicationUser recipient, List<String> eligibleDisplayNames, String countRemainingI18nKey) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(recipient);
        return this.renderDisplayNames(i18nHelper, eligibleDisplayNames, countRemainingI18nKey);
    }

    private List<String> renderDisplayNames(I18nHelper i18nHelper, List<String> eligibleDisplayNames, String countRemainingI18nKey) {
        return this.handleMultipleNamesSharedWith(i18nHelper, eligibleDisplayNames, countRemainingI18nKey, eligibleDisplayNames.size());
    }

    private List<String> handleMultipleNamesSharedWith(I18nHelper i18nHelper, List<String> namesToDisplay, String countRemainingI18nKey, int numberOfNamesSharedWith) {
        if (numberOfNamesSharedWith <= 4) {
            return namesToDisplay;
        }
        int numberOfNamesToShow = 3;
        return this.truncateNamesSharedWith(i18nHelper, namesToDisplay, countRemainingI18nKey, numberOfNamesToShow, numberOfNamesSharedWith - numberOfNamesToShow);
    }

    private List<String> truncateNamesSharedWith(I18nHelper i18nHelper, List<String> eligibleDisplayNames, String countRemainingI18nKey, int numberOfNamesToShow, int numberOfRemainingNames) {
        List<String> names = eligibleDisplayNames.stream().limit(numberOfNamesToShow).collect(Collectors.toList());
        names.add(i18nHelper.getText(countRemainingI18nKey, (Object)numberOfRemainingNames));
        return names;
    }
}

