/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.issue;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.api.feature.reqparticipants.organization.CustomerOrganizationParticipantService;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.issue.RequestSharedWithListHelper;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
class OrganisationSharedWithListBuilder {
    private static final String ORGANISATION_SHARED_WITH_TRUNCATED_NAMES = "sd.notifications.footer.organisations.shared.with.number.truncated";
    private static final List<String> PREVIEW_ORGANISATION_NAMES = ImmutableList.of((Object)"Alpha");
    private final CustomerOrganizationParticipantService organisationParticipantService;
    private final RequestSharedWithListHelper requestSharedWithListHelper;

    @Autowired
    OrganisationSharedWithListBuilder(CustomerOrganizationParticipantService organisationParticipantService, RequestSharedWithListHelper requestSharedWithListHelper) {
        this.organisationParticipantService = organisationParticipantService;
        this.requestSharedWithListHelper = requestSharedWithListHelper;
    }

    List<String> buildSharedWithList(ApplicationUser applicationUser, Issue issue) {
        List<String> eligibleDisplayNames = this.getSharedWithDisplayNames(issue);
        return this.requestSharedWithListHelper.buildSharedWithList(applicationUser, eligibleDisplayNames, ORGANISATION_SHARED_WITH_TRUNCATED_NAMES);
    }

    List<String> buildPreviewSharedWithList(ApplicationUser applicationUser) {
        return this.requestSharedWithListHelper.buildSharedWithList(applicationUser, PREVIEW_ORGANISATION_NAMES, ORGANISATION_SHARED_WITH_TRUNCATED_NAMES);
    }

    private List<String> getSharedWithDisplayNames(Issue issue) {
        return ((Collection)this.organisationParticipantService.getOrganizationsForIssueIgnorePermissionCheck(issue).getOrElse(Collections.emptyList())).stream().map(CustomerOrganization::getName).collect(Collectors.toList());
    }
}

