/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariablePreviewRenderingHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableRenderer;
import io.atlassian.fugue.Either;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageContentRenderer
implements VariableRenderer {
    private static final String SOY_PLUGIN_KEY = "com.atlassian.servicedesk.servicedesk-notifications-plugin:soy";
    private static final String HTML_BATCH_TEMPLATE = "ServiceDesk.Internal.Notifications.Feature.Batching.Templates.Content.html";
    private final I18nHelper.BeanFactory i18nFactory;
    private final SoyTemplateRenderer soyTemplateRenderer;

    @Autowired
    public MessageContentRenderer(I18nHelper.BeanFactory i18nFactory, SoyTemplateRenderer soyTemplateRenderer) {
        this.i18nFactory = i18nFactory;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        if (NotificationRenderFormat.HTML.equals((Object)context.getNotificationRenderFormat())) {
            return this.renderHtml(context);
        }
        return this.renderPlainText(context);
    }

    @Override
    public Either<AnError, String> renderPreview(VariableContext variableContext, NotificationPreviewContext previewContext) {
        return VariablePreviewRenderingHelper.getPreviewDataFromContext(previewContext, variableContext, () -> Either.right((Object)this.renderBuiltInPreviewData(previewContext)));
    }

    private String renderBuiltInPreviewData(NotificationPreviewContext previewContext) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(previewContext.getPreviewingUser().forJIRA());
        String preview = i18nHelper.getText("sd.notifications.preview.rendering.message.content");
        if (previewContext.getRenderFormat() == NotificationRenderFormat.HTML) {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("notifications", Collections.singletonList(this.preparePreviewContent(preview)));
            return this.soyTemplateRenderer.render(SOY_PLUGIN_KEY, HTML_BATCH_TEMPLATE, params);
        }
        return preview;
    }

    private String preparePreviewContent(String content) {
        return String.format("<p>%s</p>", content);
    }

    private Either<AnError, String> renderHtml(RenderContext context) {
        return Either.right((Object)context.getHtmlMessageContent().getOrThrow(() -> new RuntimeException("if you want to render html content it has to be there!")));
    }

    private Either<AnError, String> renderPlainText(RenderContext context) {
        return Either.right((Object)context.getPlainTextMessageContent().getOrThrow(() -> new RuntimeException("if you want to render plain text content it has to be there!")));
    }
}

