/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.fixedcontent;

import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.message.StylingPreviewMessageField;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.fixedcontent.StylingFixedContentRenderer;
import com.google.common.annotations.VisibleForTesting;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StylingPreviewFixedLayoutRenderer {
    private final StylingFixedContentRenderer stylingFixedContentRenderer;

    @Autowired
    public StylingPreviewFixedLayoutRenderer(StylingFixedContentRenderer stylingFixedContentRenderer) {
        this.stylingFixedContentRenderer = stylingFixedContentRenderer;
    }

    public String addRequiredMessageElements(NotificationPreviewContext context, String content) {
        if (context.getRenderFormat() == NotificationRenderFormat.HTML) {
            return this.addAdditionalContentHtml(context, content);
        }
        return this.addAdditionalContentPlainText(context, content);
    }

    @VisibleForTesting
    boolean shouldInsertReplyAboveMarker(NotificationPreviewContext context) {
        if (context.getStylingPreviewMessageField() == StylingPreviewMessageField.BODY) {
            return this.stylingFixedContentRenderer.shouldAddReplyAboveMarkerForProject(context.getProject());
        }
        return false;
    }

    private String addAdditionalContentHtml(NotificationPreviewContext context, String content) {
        boolean insertReplyAbove = this.shouldInsertReplyAboveMarker(context);
        return this.stylingFixedContentRenderer.addContentToHtmlTemplate(context.getLocale(), content, insertReplyAbove);
    }

    private String addAdditionalContentPlainText(NotificationPreviewContext context, String content) {
        boolean insertReplyAbove = this.shouldInsertReplyAboveMarker(context);
        return this.stylingFixedContentRenderer.addContentToPlainTextTemplate(context.getLocale(), content, insertReplyAbove);
    }
}

