/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.styling;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.notifications.render.RenderedHtmlContent;
import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;

public class StylingRenderParams {
    private final ApplicationUser recipient;
    private final Project project;
    private final Option<Issue> issueOption;
    private final Option<String> htmlContent;
    private final String plainTextContent;

    public StylingRenderParams(ApplicationUser recipient, Either<String, RenderedHtmlContent> content, Project project, Option<Issue> issueOption) {
        if (content.isRight()) {
            this.plainTextContent = ((RenderedHtmlContent)content.right().get()).getTextContent();
            this.htmlContent = Option.some((Object)((RenderedHtmlContent)content.right().get()).getHtmlContent());
        } else {
            this.plainTextContent = (String)content.left().get();
            this.htmlContent = Option.none();
        }
        this.recipient = recipient;
        this.project = project;
        this.issueOption = issueOption;
    }

    public ApplicationUser getRecipient() {
        return this.recipient;
    }

    public Option<String> getHtmlContent() {
        return this.htmlContent;
    }

    public String getPlainTextContent() {
        return this.plainTextContent;
    }

    public Project getProject() {
        return this.project;
    }

    public Option<Issue> getIssueOption() {
        return this.issueOption;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("recipient", (Object)this.recipient).add("project", (Object)this.project).add("issueOption", this.issueOption).add("htmlContent", this.htmlContent).add("plainTextContent", (Object)this.plainTextContent).toString();
    }
}

