/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.misc;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.AbstractContentVariableRenderer;
import io.atlassian.fugue.Either;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalNameVariableRenderer
extends AbstractContentVariableRenderer {
    private final PortalManager portalManager;

    @Autowired
    public PortalNameVariableRenderer(ErrorResultHelper errorResultHelper, NotificationRendererUtils notificationRendererUtils, I18nHelper.BeanFactory i18nBeanFactory, PortalManager portalManager) {
        super(errorResultHelper, notificationRendererUtils, i18nBeanFactory);
        this.portalManager = portalManager;
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        return this.renderPortalName(context.getProject(), context.getNotificationRenderFormat());
    }

    @Override
    public Either<AnError, String> renderPlainTextValue(RenderContext context) {
        return this.renderPortalName(context.getProject(), NotificationRenderFormat.PLAIN_TEXT);
    }

    @Override
    protected Either<AnError, AbstractContentVariableRenderer.VariablePreviewData> getVariablePreviewData(NotificationPreviewContext previewContext) {
        return this.renderPortalName(previewContext.getProject(), previewContext.getRenderFormat()).map(AbstractContentVariableRenderer::unTranslatedPreviewData);
    }

    private Either<AnError, String> renderPortalName(Project project, NotificationRenderFormat format) {
        String rawName = (String)this.portalManager.getPortalByProject(project).fold(e -> StringUtils.defaultString((String)project.getName()), Portal::getName);
        return Either.right((Object)this.sanitisePlainTextValue(rawName, format));
    }
}

