/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.AbstractContentVariableRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueSummaryVariableRenderer
extends AbstractContentVariableRenderer {
    @Autowired
    public IssueSummaryVariableRenderer(ErrorResultHelper errorResultHelper, NotificationRendererUtils notificationRendererUtils, I18nHelper.BeanFactory i18nBeanFactory) {
        super(errorResultHelper, notificationRendererUtils, i18nBeanFactory);
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        return this.render(context.getIssue(), context.getNotificationRenderFormat());
    }

    @Override
    public Either<AnError, String> renderPlainTextValue(RenderContext context) {
        return this.render(context.getIssue(), NotificationRenderFormat.PLAIN_TEXT);
    }

    @Override
    protected Either<AnError, AbstractContentVariableRenderer.VariablePreviewData> getVariablePreviewData(NotificationPreviewContext previewContext) {
        return Either.right((Object)IssueSummaryVariableRenderer.translatedPreviewData("sd.notifications.preview.rendering.issue.summary"));
    }

    private Either<AnError, String> render(Option<Issue> issueOpt, NotificationRenderFormat format) {
        return this.checkIssueContext(issueOpt, ContentVariable.ISSUE_SUMMARY).map(issue -> this.render((Issue)issue, format));
    }

    private String render(Issue issue, NotificationRenderFormat format) {
        return (String)Option.option((Object)issue.getSummary()).fold(() -> "", summary -> this.renderFormattedFieldValue((String)summary, "summary", issue, format));
    }
}

