/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.feature.customer.request.CustomerRequestStatusManager;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.AbstractContentVariableRenderer;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueRequestStatusVariableRenderer
extends AbstractContentVariableRenderer {
    private final CustomerRequestStatusManager customerRequestStatusManager;

    @Autowired
    public IssueRequestStatusVariableRenderer(ErrorResultHelper errorResultHelper, NotificationRendererUtils notificationRendererUtils, I18nHelper.BeanFactory i18nBeanFactory, CustomerRequestStatusManager customerRequestStatusManager) {
        super(errorResultHelper, notificationRendererUtils, i18nBeanFactory);
        this.customerRequestStatusManager = customerRequestStatusManager;
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        return Steps.begin(this.checkIssueContext(context.getIssue(), ContentVariable.REQUEST_STATUS)).then(issue -> this.customerRequestStatusManager.retrieveRequestStatus(context.getRecipient(), issue)).yield((issue, status) -> this.sanitisePlainTextValue((String)status, context.getNotificationRenderFormat()));
    }

    @Override
    protected Either<AnError, AbstractContentVariableRenderer.VariablePreviewData> getVariablePreviewData(NotificationPreviewContext previewContext) {
        return Either.right((Object)IssueRequestStatusVariableRenderer.translatedPreviewData("sd.notifications.preview.rendering.issue.status"));
    }
}

