/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.analytics.ServiceDeskAnalyticsSourceService;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.internal.api.project.PortalUrls;
import com.atlassian.servicedesk.internal.api.project.PortalUrlsProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderMode;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.AbstractContentVariableRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueRequestLinkVariableRenderer
extends AbstractContentVariableRenderer {
    private final ErrorResultHelper errorResultHelper;
    private final VpOriginCustomFieldService vpOriginCustomFieldService;
    private final PortalManager portalManager;
    private final PortalUrlsProvider portalUrlsProvider;
    private final ServiceDeskAnalyticsSourceService serviceDeskAnalyticsSourceService;

    @Autowired
    public IssueRequestLinkVariableRenderer(ErrorResultHelper errorResultHelper, NotificationRendererUtils notificationRendererUtils, I18nHelper.BeanFactory i18nBeanFactory, VpOriginCustomFieldService vpOriginCustomFieldService, PortalManager portalManager, PortalUrlsProvider portalUrlsProvider, ServiceDeskAnalyticsSourceService serviceDeskAnalyticsSourceService) {
        super(errorResultHelper, notificationRendererUtils, i18nBeanFactory);
        this.errorResultHelper = errorResultHelper;
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.portalManager = portalManager;
        this.portalUrlsProvider = portalUrlsProvider;
        this.serviceDeskAnalyticsSourceService = serviceDeskAnalyticsSourceService;
    }

    @Override
    public boolean shouldBeWikiRendered(Option<RecipientNotificationMessage> message) {
        return true;
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        return Steps.begin(this.checkIssueContext(context.getIssue(), ContentVariable.REQUEST_URL)).then(issue -> this.checkIssueKeyNotEmpty(issue.getKey(), ContentVariable.REQUEST_URL)).yield((issue, issueKey) -> this.checkRequestTypeAndGetPortalLink((Issue)issue, context));
    }

    private Either<AnError, String> checkIssueKeyNotEmpty(String issueKey, ContentVariable notificationVariable) {
        if (StringUtils.isEmpty((String)issueKey)) {
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.notifications.base.content.used.variable.issue.key.missing", new Object[]{notificationVariable.getVariable()}).build());
        }
        return Either.right((Object)issueKey);
    }

    private String checkRequestTypeAndGetPortalLink(Issue issue, RenderContext context) {
        if (issue.getCustomFieldValue(this.vpOriginCustomFieldService.getVpOriginCustomField()) == null) {
            return "";
        }
        return this.wrapPortalLinkIfApplicable(this.getPortalAndPortalLinkForIssue(issue.getKey(), context), context.getVariableContext(), context.getNotificationRenderFormat(), context.getRenderMode());
    }

    private String wrapPortalLinkIfApplicable(String portalLink, VariableContext variableContext, NotificationRenderFormat format, RenderMode renderMode) {
        if (this.portalLinkShouldBeWrapped(portalLink, variableContext, format, renderMode)) {
            return "[" + portalLink + "]";
        }
        return portalLink;
    }

    private boolean portalLinkShouldBeWrapped(String portalLink, VariableContext variableContext, NotificationRenderFormat format, RenderMode renderMode) {
        return format.equals((Object)NotificationRenderFormat.HTML) && RenderMode.CONTENT.equals((Object)renderMode) && StringUtils.isNotEmpty((String)portalLink) && (!variableContext.getCharactersAfter().equals("]") || !variableContext.getCharactersBefore().equals("|") && !variableContext.getCharactersBefore().equals("["));
    }

    private String getPortalAndPortalLinkForIssue(@Nonnull String issueKey, @Nonnull RenderContext context) {
        return (String)this.portalManager.getPortalByProject(context.getProject()).fold(e -> "", portal -> this.getPortalLinkForIssue(issueKey, (Portal)portal));
    }

    private String getPortalLinkForIssue(@Nonnull String issueKey, @Nonnull Portal portal) {
        PortalUrls portalUrls = this.portalUrlsProvider.getUrls(portal.getId(), ProjectUrlsProvider.UrlMode.ABSOLUTE);
        try {
            String url = portalUrls.request(issueKey).toString();
            return this.serviceDeskAnalyticsSourceService.enrichURLWithSDASource(url, "notification-email");
        }
        catch (IllegalStateException e) {
            return "";
        }
    }

    @Override
    public Either<AnError, String> renderPreview(VariableContext variable, NotificationPreviewContext previewContext) {
        return super.renderPreview(variable, previewContext).map(renderedValue -> this.wrapPortalLinkIfApplicable((String)renderedValue, variable, previewContext.getRenderFormat(), previewContext.getRenderMode()));
    }

    @Override
    protected Either<AnError, AbstractContentVariableRenderer.VariablePreviewData> getVariablePreviewData(NotificationPreviewContext previewContext) {
        return this.portalManager.getPortalByProjectKey(previewContext.getProject().getKey()).map(portal -> {
            String portalUrl = this.portalUrlsProvider.getUrls(portal.getId(), ProjectUrlsProvider.UrlMode.ABSOLUTE).portal().toString();
            return IssueRequestLinkVariableRenderer.unTranslatedPreviewData(portalUrl);
        });
    }
}

