/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.AbstractContentVariableRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueKeyVariableRenderer
extends AbstractContentVariableRenderer {
    @Autowired
    public IssueKeyVariableRenderer(ErrorResultHelper errorResultHelper, NotificationRendererUtils notificationRendererUtils, I18nHelper.BeanFactory i18nBeanFactory) {
        super(errorResultHelper, notificationRendererUtils, i18nBeanFactory);
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        return this.render(context.getIssue());
    }

    @Override
    public Either<AnError, String> renderPlainTextValue(RenderContext context) {
        return this.render(context.getIssue());
    }

    @Override
    protected Either<AnError, AbstractContentVariableRenderer.VariablePreviewData> getVariablePreviewData(NotificationPreviewContext previewContext) {
        return Either.right((Object)IssueKeyVariableRenderer.unTranslatedPreviewData("BB-8"));
    }

    private Either<AnError, String> render(Option<Issue> issueOpt) {
        return this.checkIssueContext(issueOpt, ContentVariable.ISSUE_KEY).map(this::render);
    }

    private String render(Issue issue) {
        return StringUtils.defaultString((String)issue.getKey());
    }
}

