/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderMode;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.AbstractContentVariableRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueDescriptionVariableRenderer
extends AbstractContentVariableRenderer {
    @Autowired
    public IssueDescriptionVariableRenderer(ErrorResultHelper errorResultHelper, NotificationRendererUtils notificationRendererUtils, I18nHelper.BeanFactory i18nBeanFactory) {
        super(errorResultHelper, notificationRendererUtils, i18nBeanFactory);
    }

    @Override
    public boolean shouldBeWikiRendered(Option<RecipientNotificationMessage> message) {
        return (Boolean)message.flatMap(NotificationMessage::getIssue).map(issue -> this.shouldBeWikiRendered((Issue)issue, RenderMode.CONTENT)).getOrElse((Object)true);
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        return this.checkIssueContext(context.getIssue(), ContentVariable.ISSUE_DESCRIPTION).map(issue -> {
            String rawDescription = this.getIssueDescription((Issue)issue);
            if (this.shouldBeWikiRendered((Issue)issue, context.getRenderMode())) {
                return rawDescription;
            }
            return this.renderFormattedFieldValue(rawDescription, "description", (Issue)issue, context.getNotificationRenderFormat());
        });
    }

    private boolean shouldBeWikiRendered(Issue issue, RenderMode renderMode) {
        if (RenderMode.STYLING.equals((Object)renderMode)) {
            return false;
        }
        JiraRendererPlugin renderer = this.notificationRendererUtils.retrieveRendererForField(issue, "description");
        return "atlassian-wiki-renderer".equals(renderer.getRendererType());
    }

    private String getIssueDescription(Issue issue) {
        return (String)Option.option((Object)issue.getDescription()).getOrElse((Object)"");
    }

    @Override
    protected Either<AnError, AbstractContentVariableRenderer.VariablePreviewData> getVariablePreviewData(NotificationPreviewContext previewContext) {
        return Either.right((Object)IssueDescriptionVariableRenderer.translatedPreviewData("sd.notifications.preview.rendering.issue.description"));
    }
}

