/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.comment;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.AbstractContentVariableRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnformattedCommentVariableRenderer
extends AbstractContentVariableRenderer {
    @Autowired
    public UnformattedCommentVariableRenderer(ErrorResultHelper errorResultHelper, NotificationRendererUtils notificationRendererUtils, I18nHelper.BeanFactory i18nBeanFactory) {
        super(errorResultHelper, notificationRendererUtils, i18nBeanFactory);
    }

    @Override
    public boolean shouldBeWikiRendered(Option<RecipientNotificationMessage> message) {
        return (Boolean)message.flatMap(NotificationMessage::getIssue).map(this::internalShouldBeWikiRendered).getOrElse((Object)true);
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        Either commentEither = context.getComment().toRight(this::provideMissingCommentContextError);
        return commentEither.map(comment -> {
            String rawCommentBody = this.getCommentBody((Comment)comment);
            if (this.internalShouldBeWikiRendered(context.getIssue())) {
                return rawCommentBody;
            }
            return this.renderFormattedFieldValue(rawCommentBody, "comment", comment.getIssue(), context.getNotificationRenderFormat());
        });
    }

    private boolean internalShouldBeWikiRendered(Option<Issue> issueOption) {
        return (Boolean)issueOption.map(this::internalShouldBeWikiRendered).getOrElse((Object)true);
    }

    private boolean internalShouldBeWikiRendered(Issue issue) {
        JiraRendererPlugin renderer = this.notificationRendererUtils.retrieveRendererForField(issue, "comment");
        return "atlassian-wiki-renderer".equals(renderer.getRendererType());
    }

    private String getCommentBody(Comment comment) {
        return (String)Option.option((Object)comment.getBody()).getOrElse((Object)"");
    }

    private AnError provideMissingCommentContextError() {
        return this.errorResultHelper.internalServiceError500("sd.notifications.base.content.comment.context.missing", new Object[]{ContentVariable.COMMENT_UNFORMATTED_CONTENT.getVariable()}).build();
    }

    @Override
    protected Either<AnError, AbstractContentVariableRenderer.VariablePreviewData> getVariablePreviewData(NotificationPreviewContext previewContext) {
        return Either.right((Object)UnformattedCommentVariableRenderer.translatedPreviewData("sd.notifications.preview.rendering.issue.comment"));
    }
}

