/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventTimeRenderer {
    private final LocaleManager localeManager;
    private final TimeZoneManager timeZoneManager;

    @Autowired
    public EventTimeRenderer(LocaleManager localeManager, TimeZoneManager timeZoneManager) {
        this.localeManager = localeManager;
        this.timeZoneManager = timeZoneManager;
    }

    public String retrieveAuthorDate(ApplicationUser recipient, Date eventTime) {
        LocalDateTime createdTime = this.retrieveLocalizedAuthorDate(recipient, eventTime);
        DateTimeFormatter formatter = this.retrieveAuthorDateFormatter(recipient);
        return createdTime.format(formatter);
    }

    private LocalDateTime retrieveLocalizedAuthorDate(ApplicationUser recipient, Date eventTime) {
        TimeZone timeZone = this.timeZoneManager.getTimeZoneforUser(recipient);
        return LocalDateTime.ofInstant(eventTime.toInstant(), timeZone.toZoneId());
    }

    private DateTimeFormatter retrieveAuthorDateFormatter(ApplicationUser recipient) {
        Locale locale = this.localeManager.getLocaleFor(recipient);
        return DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).withLocale(locale);
    }
}

