/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthorNameRenderer {
    private static final String ANONYMOUS_I18N_KEY = "sd.notifications.rendering.variable.formatted.author.anonymous";
    private final UserFactory userFactory;
    private final I18nHelper.BeanFactory i18nBeanFactory;

    @Autowired
    public AuthorNameRenderer(UserFactory userFactory, I18nHelper.BeanFactory i18nBeanFactory) {
        this.userFactory = userFactory;
        this.i18nBeanFactory = i18nBeanFactory;
    }

    public String retrieveAuthorName(ApplicationUser recipient, Option<ApplicationUser> author) {
        return (String)author.flatMap(user -> StepsConverters.newerOption((com.atlassian.fugue.Option)this.userFactory.wrap(user).toOption())).map(CheckedUser::getDisplayName).getOr(() -> this.retrieveAnonymousAuthorName(recipient));
    }

    private String retrieveAnonymousAuthorName(ApplicationUser recipient) {
        I18nHelper i18nHelper = this.i18nBeanFactory.getInstance(recipient);
        return i18nHelper.getText(ANONYMOUS_I18N_KEY);
    }
}

