/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageMetaData;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.ContentVariableReplacementManager;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.ContentVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.comment.UnformattedCommentVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueDescriptionVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueKeyVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueReporterVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueRequestLinkVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueRequestStatusVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueResolutionVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueSummaryVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.misc.EventAuthorVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.misc.PortalNameVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.misc.RecipientNameVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.resolution.FormattedResolutionRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.status.FormattedStatusChangeRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ContentVariableReplacementManagerImpl
implements ContentVariableReplacementManager {
    @TenantAware(value=TenancyScope.TENANTLESS)
    @VisibleForTesting
    final Map<ContentVariable, ContentVariableRenderer> variableRenderers;

    @Autowired
    public ContentVariableReplacementManagerImpl(FormattedStatusChangeRenderer formattedStatusChangeRenderer, FormattedResolutionRenderer formattedResolutionRenderer, IssueKeyVariableRenderer issueKeyVariableRenderer, IssueDescriptionVariableRenderer issueDescriptionVariableRenderer, IssueSummaryVariableRenderer issueSummaryVariableRenderer, IssueResolutionVariableRenderer issueResolutionVariableRenderer, IssueReporterVariableRenderer issueReporterVariableRenderer, IssueRequestLinkVariableRenderer issueRequestLinkVariableRenderer, IssueRequestStatusVariableRenderer issueRequestStatusVariableRenderer, UnformattedCommentVariableRenderer commentUnformattedVariableRenderer, RecipientNameVariableRenderer recipientNameVariableRenderer, EventAuthorVariableRenderer eventAuthorVariableRenderer, PortalNameVariableRenderer portalNameVariableRenderer) {
        this.variableRenderers = ImmutableMap.builder().put((Object)ContentVariable.ISSUE_KEY, (Object)issueKeyVariableRenderer).put((Object)ContentVariable.ISSUE_DESCRIPTION, (Object)issueDescriptionVariableRenderer).put((Object)ContentVariable.ISSUE_SUMMARY, (Object)issueSummaryVariableRenderer).put((Object)ContentVariable.ISSUE_RESOLUTION, (Object)issueResolutionVariableRenderer).put((Object)ContentVariable.ISSUE_REPORTER, (Object)issueReporterVariableRenderer).put((Object)ContentVariable.REQUEST_LINK, (Object)issueRequestLinkVariableRenderer).put((Object)ContentVariable.REQUEST_URL, (Object)issueRequestLinkVariableRenderer).put((Object)ContentVariable.REQUEST_STATUS_UNFORMATTED, (Object)issueRequestStatusVariableRenderer).put((Object)ContentVariable.REQUEST_STATUS_OLD, (Object)issueRequestStatusVariableRenderer).put((Object)ContentVariable.REQUEST_STATUS, (Object)issueRequestStatusVariableRenderer).put((Object)ContentVariable.COMMENT_CONTENT, (Object)commentUnformattedVariableRenderer).put((Object)ContentVariable.COMMENT_UNFORMATTED_CONTENT, (Object)commentUnformattedVariableRenderer).put((Object)ContentVariable.RECIPIENT_NAME, (Object)recipientNameVariableRenderer).put((Object)ContentVariable.EVENT_USER_NAME, (Object)eventAuthorVariableRenderer).put((Object)ContentVariable.PROJECT_PORTAL_NAME, (Object)portalNameVariableRenderer).put((Object)ContentVariable.PORTAL_NAME, (Object)portalNameVariableRenderer).put((Object)ContentVariable.REQUEST_RESOLUTION_UPDATE, (Object)formattedResolutionRenderer).put((Object)ContentVariable.REQUEST_STATUS_UPDATE, (Object)formattedStatusChangeRenderer).build();
    }

    @Override
    public boolean shouldBeWikiRendered(Option<RecipientNotificationMessage> message, NotificationVariable variable) {
        return this.variableRenderers.get(variable).shouldBeWikiRendered(message);
    }

    @Override
    public Either<AnError, String> retrievePlainTextReplacement(NotificationVariable variable, NotificationMessageMetaData metaData) {
        RenderContext context = RenderContext.create(variable, metaData);
        return this.variableRenderers.get(variable).renderPlainTextValue(context);
    }

    @Override
    public Either<AnError, String> retrieveReplacement(VariableContext variableContext, RecipientNotificationMessage message, NotificationRenderFormat notificationRenderFormat) {
        RenderContext context = RenderContext.create(variableContext, message, notificationRenderFormat);
        return this.variableRenderers.get(variableContext.getNotificationVariable()).render(context);
    }

    @Override
    public Either<AnError, String> retrievePreviewReplacement(VariableContext variableContext, NotificationPreviewContext message, NotificationRenderFormat notificationRenderFormat) {
        return this.variableRenderers.get(variableContext.getNotificationVariable()).renderPreview(variableContext, message);
    }
}

