/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationContext;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.ReplacementInformation;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableReplacementUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.ContentVariableReplacementManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentPreviewRenderer {
    private final ContentVariableReplacementManager variableReplacementManager;

    @Autowired
    public ContentPreviewRenderer(ContentVariableReplacementManager variableReplacementManager) {
        this.variableReplacementManager = variableReplacementManager;
    }

    public Either<AnError, String> renderPreviewBeforeWikiRendering(NotificationPreviewContext context) {
        if (context.getRenderFormat() == NotificationRenderFormat.HTML) {
            return VariableReplacementUtils.replaceVariables(context, context.getRawContent(), VariableReplacementUtils.EXTERNAL_VARIABLE_PATTERN, this::replaceVariablePreviewAsHtmlBeforeWikiRendering);
        }
        return VariableReplacementUtils.replaceVariables(context, context.getRawContent(), VariableReplacementUtils.EXTERNAL_VARIABLE_PATTERN, this::replaceVariablePreviewAsPlainTextBeforeWikiRendering);
    }

    public Either<AnError, String> renderPreviewAfterWikiRendering(NotificationPreviewContext context, String content) {
        if (context.getRenderFormat() == NotificationRenderFormat.HTML) {
            return VariableReplacementUtils.replaceVariables(context, content, VariableReplacementUtils.INTERNAL_VARIABLE_PATTERN, this::replaceVariablePreviewAsHtmlAfterWikiRendering);
        }
        return VariableReplacementUtils.replaceVariables(context, content, VariableReplacementUtils.INTERNAL_VARIABLE_PATTERN, this::replaceVariablePreviewAsPlainTextAfterWikiRendering);
    }

    private Either<AnError, String> replaceVariablePreviewAsHtmlBeforeWikiRendering(ReplacementInformation<NotificationPreviewContext> replacementInformation) {
        return this.replaceVariablePreviewBeforeWikiRendering(replacementInformation, NotificationRenderFormat.HTML);
    }

    private Either<AnError, String> replaceVariablePreviewAsPlainTextBeforeWikiRendering(ReplacementInformation<NotificationPreviewContext> replacementInformation) {
        return this.replaceVariablePreviewBeforeWikiRendering(replacementInformation, NotificationRenderFormat.PLAIN_TEXT);
    }

    private Either<AnError, String> replaceVariablePreviewAsHtmlAfterWikiRendering(ReplacementInformation<NotificationPreviewContext> replacementInformation) {
        return this.replaceVariablePreviewAfterWikiRendering(replacementInformation, NotificationRenderFormat.HTML);
    }

    private Either<AnError, String> replaceVariablePreviewAsPlainTextAfterWikiRendering(ReplacementInformation<NotificationPreviewContext> replacementInformation) {
        return this.replaceVariablePreviewAfterWikiRendering(replacementInformation, NotificationRenderFormat.PLAIN_TEXT);
    }

    private Either<AnError, String> replaceVariablePreviewBeforeWikiRendering(ReplacementInformation<NotificationPreviewContext> replacementInformation, NotificationRenderFormat notificationRenderFormat) {
        String variableKey = replacementInformation.getVariableKey();
        return (Either)ContentVariable.forVariable(variableKey).fold(() -> Either.right((Object)VariableReplacementUtils.createInternalVariableFormat(variableKey)), variable -> {
            if (this.isVariableInContext((NotificationVariable)variable, ((NotificationPreviewContext)replacementInformation.getMessage()).getNotificationContexts()) && this.variableReplacementManager.shouldBeWikiRendered((Option<RecipientNotificationMessage>)Option.none(), (NotificationVariable)variable)) {
                return this.retrieveReplacement((NotificationVariable)variable, replacementInformation, notificationRenderFormat);
            }
            return Either.right((Object)VariableReplacementUtils.createInternalVariableFormat(variableKey));
        });
    }

    private Either<AnError, String> replaceVariablePreviewAfterWikiRendering(ReplacementInformation<NotificationPreviewContext> replacementInformation, NotificationRenderFormat notificationRenderFormat) {
        String variableKey = replacementInformation.getVariableKey();
        return (Either)ContentVariable.forVariable(variableKey).fold(() -> Either.right((Object)VariableReplacementUtils.createExternalVariableFormat(variableKey)), variable -> {
            if (this.isVariableInContext((NotificationVariable)variable, ((NotificationPreviewContext)replacementInformation.getMessage()).getNotificationContexts())) {
                return this.retrieveReplacement((NotificationVariable)variable, replacementInformation, notificationRenderFormat);
            }
            return Either.right((Object)VariableReplacementUtils.createExternalVariableFormat(variableKey));
        });
    }

    private Either<AnError, String> retrieveReplacement(NotificationVariable variable, ReplacementInformation<NotificationPreviewContext> replacementInformation, NotificationRenderFormat notificationRenderFormat) {
        VariableContext variableContext = new VariableContext(variable, replacementInformation.getCharacterBefore(), replacementInformation.getCharacterAfter());
        return this.variableReplacementManager.retrievePreviewReplacement(variableContext, replacementInformation.getMessage(), notificationRenderFormat);
    }

    private boolean isVariableInContext(NotificationVariable notificationVariable, Set<NotificationContext> contexts) {
        return contexts.contains((Object)notificationVariable.getContext());
    }
}

