/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables;

import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.StylingVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.ResolvedVariables;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableReplacementUtils;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class VariableResolutionManager {
    public ResolvedVariables resolveVariables(String content, Set<? extends NotificationVariable> validVariables) {
        Set<String> allVariables = VariableReplacementUtils.extractAllExternalVariable(content);
        Set<NotificationVariable> usedValidVariables = allVariables.stream().flatMap(variableKey -> (Stream)VariableResolutionManager.toNotificationVariable(variableKey).fold(Stream::empty, Stream::of)).filter(validVariables::contains).collect(Collectors.toSet());
        Set usedValidVariableKeys = usedValidVariables.stream().map(NotificationVariable::getVariable).collect(Collectors.toSet());
        Set<String> invalidVariables = Sets.difference(allVariables, usedValidVariableKeys).stream().map(VariableReplacementUtils::createExternalVariableFormat).collect(Collectors.toSet());
        return new ResolvedVariables(usedValidVariables, invalidVariables);
    }

    public static Option<NotificationVariable> toNotificationVariable(String variableKey) {
        return StylingVariable.forVariable(variableKey).orElse(ContentVariable.forVariable(variableKey));
    }
}

