/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.ReplacementInformation;
import io.atlassian.fugue.Either;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VariableReplacementUtils {
    private static final String INTERNAL_PATTERN_PRE_SUFFIX = "%%%%%SD-RENDER%%%%%";
    private static final String VARIABLE_NAME_REGEXP = "([a-zA-Z0-9.]*?)";
    public static final Pattern EXTERNAL_VARIABLE_PATTERN = Pattern.compile("(.?)\\$\\{([a-zA-Z0-9.]*?)\\}(.?)");
    public static final Pattern INTERNAL_VARIABLE_PATTERN = Pattern.compile("(.?)%%%%%SD-RENDER%%%%%([a-zA-Z0-9.]*?)%%%%%SD-RENDER%%%%%(.?)");

    public static String createExternalVariableFormat(String variableName) {
        return "${" + variableName + "}";
    }

    public static String createInternalVariableFormat(String variableKey) {
        return INTERNAL_PATTERN_PRE_SUFFIX + variableKey + INTERNAL_PATTERN_PRE_SUFFIX;
    }

    public static <Message> Either<AnError, String> replaceVariables(Message message, String stringToReplace, Pattern pattern, Function<ReplacementInformation, Either<AnError, String>> replacementFunction) {
        Matcher matcher = pattern.matcher(stringToReplace);
        StringBuilder stringBuilder = new StringBuilder();
        int currentStartIndex = 0;
        while (matcher.find(currentStartIndex)) {
            String characterBefore = matcher.group(1);
            String variableKey = matcher.group(2);
            String characterAfter = matcher.group(3);
            stringBuilder.append(stringToReplace.substring(currentStartIndex, matcher.start())).append(characterBefore);
            Either<AnError, String> replacement = replacementFunction.apply(new ReplacementInformation<Message>(variableKey, message, characterBefore, characterAfter));
            if (replacement.isLeft()) {
                return replacement;
            }
            stringBuilder.append((String)replacement.right().get());
            currentStartIndex = VariableReplacementUtils.getNextStartIndex(characterAfter, matcher.end());
        }
        stringBuilder.append(stringToReplace.substring(currentStartIndex));
        return Either.right((Object)stringBuilder.toString());
    }

    static int getNextStartIndex(String characterAfter, int endIndexOfLastMatch) {
        if (characterAfter.equals("")) {
            return endIndexOfLastMatch;
        }
        return endIndexOfLastMatch - characterAfter.length();
    }

    public static Set<String> extractAllExternalVariable(String content) {
        Matcher matcher = EXTERNAL_VARIABLE_PATTERN.matcher(content);
        HashSet<String> variables = new HashSet<String>();
        int startIndex = 0;
        while (matcher.find(startIndex)) {
            String variable = matcher.group(2);
            variables.add(variable);
            startIndex = VariableReplacementUtils.getNextStartIndex(matcher.group(3), matcher.end());
        }
        return Collections.unmodifiableSet(variables);
    }

    private VariableReplacementUtils() {
    }
}

