/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.StatusChange;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageMetaData;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderMode;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.StylingRenderParams;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.atlassian.fugue.Option;
import java.util.Date;

public class RenderContext {
    private final VariableContext variableContext;
    private final NotificationRenderFormat notificationRenderFormat;
    private final Project project;
    private final ApplicationUser recipient;
    private final Option<Comment> comment;
    private final Option<Issue> issue;
    private final Option<ApplicationUser> eventAuthor;
    private final Option<String> htmlMessageContent;
    private final Option<String> plainTextMessageContent;
    private final RenderMode renderMode;
    private final Date eventTime;
    private final Option<FieldChangeType> resolutionChangeType;
    private final Option<StatusChange> statusChange;

    public static RenderContext create(NotificationVariable variable, NotificationMessageMetaData metaData) {
        return new Builder().variableContext(new VariableContext(variable, "", "")).project(metaData.getProject()).issue((Option<Issue>)metaData.getIssue()).recipient(metaData.getRecipient()).resolutionChangeType((Option<FieldChangeType>)metaData.getResolutionChange()).notificationRenderFormat(NotificationRenderFormat.PLAIN_TEXT).renderMode(RenderMode.CONTENT).build();
    }

    public static RenderContext create(VariableContext variableContext, RecipientNotificationMessage message, NotificationRenderFormat notificationRenderFormat) {
        return new Builder().variableContext(variableContext).notificationRenderFormat(notificationRenderFormat).project(message.getProject()).recipient(message.getRecipient()).comment((Option<Comment>)message.getComment()).issue((Option<Issue>)message.getIssue()).eventAuthor((Option<ApplicationUser>)message.getEventInitiator()).eventTime(message.getEventTime()).resolutionChangeType((Option<FieldChangeType>)message.getResolutionChangeType()).statusChange((Option<StatusChange>)message.getStatusChange()).renderMode(RenderMode.CONTENT).build();
    }

    public static RenderContext create(VariableContext variableContext, StylingRenderParams stylingRenderParams, NotificationRenderFormat notificationRenderFormat) {
        return new Builder().variableContext(variableContext).notificationRenderFormat(notificationRenderFormat).project(stylingRenderParams.getProject()).recipient(stylingRenderParams.getRecipient()).issue((Option<Issue>)stylingRenderParams.getIssueOption()).htmlMessageContent((Option<String>)stylingRenderParams.getHtmlContent()).plainTextMessageContent((Option<String>)Option.some((Object)stylingRenderParams.getPlainTextContent())).renderMode(RenderMode.STYLING).build();
    }

    private RenderContext(VariableContext variableContext, NotificationRenderFormat notificationRenderFormat, Project project, Option<Comment> comment, Option<Issue> issue, ApplicationUser recipient, Option<ApplicationUser> eventAuthor, Option<String> htmlMessageContent, Option<String> plainTextMessageContent, RenderMode renderMode, Date eventTime, Option<FieldChangeType> resolutionChangeType, Option<StatusChange> statusChange) {
        this.variableContext = variableContext;
        this.notificationRenderFormat = notificationRenderFormat;
        this.project = project;
        this.comment = comment;
        this.issue = issue;
        this.recipient = recipient;
        this.eventAuthor = eventAuthor;
        this.htmlMessageContent = htmlMessageContent;
        this.plainTextMessageContent = plainTextMessageContent;
        this.renderMode = renderMode;
        this.eventTime = eventTime;
        this.resolutionChangeType = resolutionChangeType;
        this.statusChange = statusChange;
    }

    public VariableContext getVariableContext() {
        return this.variableContext;
    }

    public NotificationRenderFormat getNotificationRenderFormat() {
        return this.notificationRenderFormat;
    }

    public Project getProject() {
        return this.project;
    }

    public Option<Comment> getComment() {
        return this.comment;
    }

    public Option<Issue> getIssue() {
        return this.issue;
    }

    public ApplicationUser getRecipient() {
        return this.recipient;
    }

    public Option<ApplicationUser> getEventAuthor() {
        return this.eventAuthor;
    }

    public Option<String> getHtmlMessageContent() {
        return this.htmlMessageContent;
    }

    public Option<String> getPlainTextMessageContent() {
        return this.plainTextMessageContent;
    }

    public RenderMode getRenderMode() {
        return this.renderMode;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public Option<FieldChangeType> getResolutionChangeType() {
        return this.resolutionChangeType;
    }

    public Option<StatusChange> getStatusChange() {
        return this.statusChange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderContext that = (RenderContext)o;
        return this.renderMode == that.renderMode && Objects.equal((Object)this.variableContext, (Object)that.variableContext) && this.notificationRenderFormat == that.notificationRenderFormat && Objects.equal((Object)this.project, (Object)that.project) && Objects.equal((Object)this.recipient, (Object)that.recipient) && Objects.equal(this.comment, that.comment) && Objects.equal(this.issue, that.issue) && Objects.equal(this.eventAuthor, that.eventAuthor) && Objects.equal(this.htmlMessageContent, that.htmlMessageContent) && Objects.equal(this.plainTextMessageContent, that.plainTextMessageContent) && Objects.equal((Object)this.eventTime, (Object)that.eventTime) && Objects.equal(this.resolutionChangeType, that.resolutionChangeType) && Objects.equal(this.statusChange, that.statusChange);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.variableContext, this.notificationRenderFormat, this.project, this.recipient, this.comment, this.issue, this.eventAuthor, this.htmlMessageContent, this.plainTextMessageContent, this.renderMode, this.eventTime, this.resolutionChangeType, this.statusChange});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("variableContext", (Object)this.variableContext).add("notificationRenderFormat", (Object)this.notificationRenderFormat).add("project", (Object)this.project).add("recipient", (Object)this.recipient).add("comment", this.comment).add("issue", this.issue).add("eventAuthor", this.eventAuthor).add("htmlMessageContent", this.htmlMessageContent).add("plainTextMessageContent", this.plainTextMessageContent).add("renderMode", (Object)this.renderMode).add("eventTime", (Object)this.eventTime).add("resolutionChangeType", this.resolutionChangeType).add("statusChange", this.statusChange).toString();
    }

    private static class Builder {
        private VariableContext variableContext;
        private NotificationRenderFormat notificationRenderFormat;
        private Project project;
        private ApplicationUser recipient;
        private Option<Comment> comment = Option.none();
        private Option<Issue> issue = Option.none();
        private Option<ApplicationUser> eventAuthor = Option.none();
        private Option<String> htmlMessageContent = Option.none();
        private Option<String> plainTextMessageContent = Option.none();
        private RenderMode renderMode;
        private Date eventTime = new Date();
        private Option<FieldChangeType> resolutionChangeType = Option.none();
        private Option<StatusChange> statusChange = Option.none();

        private Builder() {
        }

        private Builder variableContext(VariableContext variableContext) {
            this.variableContext = variableContext;
            return this;
        }

        private Builder notificationRenderFormat(NotificationRenderFormat notificationRenderFormat) {
            this.notificationRenderFormat = notificationRenderFormat;
            return this;
        }

        private Builder project(Project project) {
            this.project = project;
            return this;
        }

        private Builder recipient(ApplicationUser recipient) {
            this.recipient = recipient;
            return this;
        }

        private Builder comment(Option<Comment> comment) {
            this.comment = comment;
            return this;
        }

        private Builder issue(Option<Issue> issue) {
            this.issue = issue;
            return this;
        }

        private Builder eventAuthor(Option<ApplicationUser> eventAuthor) {
            this.eventAuthor = eventAuthor;
            return this;
        }

        private Builder htmlMessageContent(Option<String> htmlMessageContent) {
            this.htmlMessageContent = htmlMessageContent;
            return this;
        }

        private Builder plainTextMessageContent(Option<String> plainTextMessageContent) {
            this.plainTextMessageContent = plainTextMessageContent;
            return this;
        }

        private Builder renderMode(RenderMode renderMode) {
            this.renderMode = renderMode;
            return this;
        }

        private Builder eventTime(Date eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        private Builder resolutionChangeType(Option<FieldChangeType> resolutionChangeType) {
            this.resolutionChangeType = resolutionChangeType;
            return this;
        }

        private Builder statusChange(Option<StatusChange> statusChange) {
            this.statusChange = statusChange;
            return this;
        }

        private RenderContext build() {
            return new RenderContext(this.variableContext, this.notificationRenderFormat, this.project, this.comment, this.issue, this.recipient, this.eventAuthor, this.htmlMessageContent, this.plainTextMessageContent, this.renderMode, this.eventTime, this.resolutionChangeType, this.statusChange);
        }
    }
}

