/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRule;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRuleBuilderHelper;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class NotificationRuleManager {
    private static final String RULE_NAME_I18N_SUFFIX = ".name";
    private static final String RULE_DESCRIPTION_I18N_SUFFIX = ".description";
    private final ErrorResultHelper errorResultHelper;
    private final NotificationRuleBuilderHelper notificationRuleBuilderHelper;
    private final I18nHelper i18nHelper;

    @Autowired
    public NotificationRuleManager(ErrorResultHelper errorResultHelper, NotificationRuleBuilderHelper notificationRuleBuilderHelper, I18nHelper i18nHelper) {
        this.errorResultHelper = errorResultHelper;
        this.notificationRuleBuilderHelper = notificationRuleBuilderHelper;
        this.i18nHelper = i18nHelper;
    }

    Either<AnError, NotificationRule> retrieveNotificationRule(RuleSet ruleSet, Set<String> provides) {
        return Steps.begin(this.retrieveThenConfiguration(ruleSet)).then(configuration -> Either.right((Object)this.retrieveRuleSetEnabled(ruleSet))).yield((configuration, enabled) -> this.createNotificationRule(ruleSet, provides, (Map<String, String>)configuration, (Boolean)enabled));
    }

    private NotificationRule createNotificationRule(RuleSet ruleSet, Set<String> provides, Map<String, String> configuration, Boolean enabled) {
        return new NotificationRule(ruleSet.getId(), this.retrieveRuleName(ruleSet), this.retrieveRuleDescription(ruleSet), ruleSet.getName(), configuration, provides, enabled, ruleSet.isSystemRuleSet());
    }

    private String retrieveRuleName(RuleSet ruleSet) {
        if (ruleSet.isSystemRuleSet()) {
            return this.i18nHelper.getText(ruleSet.getName());
        }
        return ruleSet.getName();
    }

    private String retrieveRuleDescription(RuleSet ruleSet) {
        if (ruleSet.isSystemRuleSet()) {
            return this.retrieveDefaultRuleDescription(ruleSet);
        }
        return (String)ruleSet.getDescription().getOrElse((Object)"");
    }

    private String retrieveDefaultRuleDescription(RuleSet ruleSet) {
        String keyPrefix = ruleSet.getName();
        if (ruleSet.getName().endsWith(RULE_NAME_I18N_SUFFIX)) {
            keyPrefix = StringUtils.substringBeforeLast((String)ruleSet.getName(), (String)RULE_NAME_I18N_SUFFIX);
        }
        String key = keyPrefix + RULE_DESCRIPTION_I18N_SUFFIX;
        return this.i18nHelper.getText(key);
    }

    ConfigurationData buildDefaultRuleConfigurationData(Map<String, String> configuration) {
        return this.notificationRuleBuilderHelper.buildDefaultRuleConfigurationData(configuration);
    }

    Either<AnError, RuleSetInput> buildRuleSetInput(RuleSet ruleSet, ConfigurationData thenActionConfiguration, boolean ruleEnabled) {
        return this.notificationRuleBuilderHelper.buildRuleSetInput(ruleSet, thenActionConfiguration, ruleEnabled);
    }

    private Either<AnError, Map<String, String>> retrieveThenConfiguration(RuleSet ruleSet) {
        Optional<Map> firstSendMailConfiguration = ruleSet.getRules().stream().flatMap(rule -> rule.getIfThens().stream()).flatMap(ifthen -> ifthen.getThen().getThenActionConfigurations().stream()).filter(this::isSendNotificationThenAction).map(thenActionConfiguration -> thenActionConfiguration.getData().getAll()).findFirst();
        return Option.fromOptional(firstSendMailConfiguration).toRight(() -> this.errorResultHelper.badRequest400("sd.notifications.rule.invalid.notification.rule", new Object[0]).build());
    }

    private Boolean retrieveRuleSetEnabled(RuleSet ruleSet) {
        return ruleSet.getRules().stream().anyMatch(Rule::isEnabled);
    }

    private boolean isSendNotificationThenAction(ThenActionConfiguration configuration) {
        return "com.atlassian.servicedesk.servicedesk-notifications-plugin:servicedesk-send-notification-action".equals(configuration.getModuleKey());
    }
}

