/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.ConfigurationDataBuilder;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class NotificationRuleBuilderHelper {
    private static final String IS_DEFAULT_RULE = "isdefaultrule";
    private final BuilderService builderService;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    NotificationRuleBuilderHelper(BuilderService builderService, ErrorResultHelper errorResultHelper) {
        this.builderService = builderService;
        this.errorResultHelper = errorResultHelper;
    }

    io.atlassian.fugue.Either<AnError, RuleSetInput> buildRuleSetInput(RuleSet ruleSet, ConfigurationData thenActionConfiguration, boolean ruleEnabled) {
        return StepsConverters.newerEither((Either)this.builderService.newBuilderFromRuleSet(ruleSet)).flatMap(builder -> this.addThenActionConfiguration((RuleSetInputBuilder)builder, thenActionConfiguration, ruleEnabled)).map(RuleSetInputBuilder::build);
    }

    ConfigurationData buildDefaultRuleConfigurationData(Map<String, String> configurationDataMap) {
        ConfigurationDataBuilder builder = this.builderService.newConfigurationDataBuilder();
        builder.putAll(configurationDataMap);
        if (!configurationDataMap.containsKey(IS_DEFAULT_RULE)) {
            builder.put(IS_DEFAULT_RULE, String.valueOf(true));
        }
        return builder.build();
    }

    private io.atlassian.fugue.Either<AnError, RuleSetInputBuilder> addThenActionConfiguration(RuleSetInputBuilder builder, ConfigurationData thenActionConfiguration, boolean ruleEnabled) {
        return this.getRule(builder).flatMap(ruleBuilder -> this.setEnabledState((RuleSetInputBuilder.RuleBuilder)ruleBuilder, ruleEnabled)).flatMap(this::getIfThen).flatMap(this::getThenActionBuilder).flatMap(this::checkThenActionBuilder).map(thenAction -> {
            thenAction.moduleKey("com.atlassian.servicedesk.servicedesk-notifications-plugin:servicedesk-send-notification-action");
            thenAction.data(thenActionConfiguration);
            return builder;
        });
    }

    private io.atlassian.fugue.Either<AnError, RuleSetInputBuilder.RuleBuilder> setEnabledState(RuleSetInputBuilder.RuleBuilder ruleBuilder, boolean ruleEnabled) {
        return io.atlassian.fugue.Either.right((Object)ruleBuilder.enabled(ruleEnabled));
    }

    private io.atlassian.fugue.Either<AnError, RuleSetInputBuilder.RuleBuilder> getRule(RuleSetInputBuilder ruleSetBuilder) {
        return this.singleValueOrError(ruleSetBuilder.getRules());
    }

    private io.atlassian.fugue.Either<AnError, RuleSetInputBuilder.IfThenBuilder> getIfThen(RuleSetInputBuilder.RuleBuilder ruleBuilder) {
        return this.singleValueOrError(ruleBuilder.getIfThens());
    }

    private io.atlassian.fugue.Either<AnError, RuleSetInputBuilder.ThenActionConfigurationBuilder> getThenActionBuilder(RuleSetInputBuilder.IfThenBuilder ifThenBuilder) {
        List thenActions = ifThenBuilder.ruleThen().thenActions();
        return this.singleValueOrError(thenActions);
    }

    private io.atlassian.fugue.Either<AnError, RuleSetInputBuilder.ThenActionConfigurationBuilder> checkThenActionBuilder(RuleSetInputBuilder.ThenActionConfigurationBuilder thenActionConfigurationBuilder) {
        if (!this.isValidThenActionConfiguration(thenActionConfigurationBuilder)) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.internalServiceError500("sd.notifications.rule.invalid.default.rule", new Object[0]).build());
        }
        return io.atlassian.fugue.Either.right((Object)thenActionConfigurationBuilder);
    }

    private <E> io.atlassian.fugue.Either<AnError, E> singleValueOrError(List<E> list) {
        if (list.size() != 1) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.badRequest400("sd.notifications.rule.invalid.default.rule", new Object[0]).build());
        }
        return io.atlassian.fugue.Either.right(list.get(0));
    }

    private boolean isValidThenActionConfiguration(RuleSetInputBuilder.ThenActionConfigurationBuilder thenActionConfigurationBuilder) {
        return thenActionConfigurationBuilder.getModuleKey().exists("com.atlassian.servicedesk.servicedesk-notifications-plugin:servicedesk-send-notification-action"::equals);
    }
}

